/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.spi;

import com.pi4j.io.spi.Spi;

public enum SpiBus {
    BUS_0(0),
    BUS_1(1),
    BUS_2(2),
    BUS_3(3),
    BUS_4(4),
    BUS_5(5),
    BUS_6(6);

    private final int bus;

    private SpiBus(int bus) {
        this.bus = bus;
    }

    public int getBus() {
        return this.bus;
    }

    public static SpiBus getByNumber(short busNumber) {
        return SpiBus.getByNumber((int)busNumber);
    }

    public static SpiBus getByNumber(int busNumber) {
        for (SpiBus item : SpiBus.values()) {
            if (item.getBus() != busNumber) continue;
            return item;
        }
        return null;
    }

    public static SpiBus parse(String bus) {
        if (bus.equalsIgnoreCase("0")) {
            return BUS_0;
        }
        if (bus.equalsIgnoreCase("1")) {
            return BUS_1;
        }
        if (bus.equalsIgnoreCase("2")) {
            return BUS_2;
        }
        if (bus.equalsIgnoreCase("3")) {
            return BUS_3;
        }
        if (bus.equalsIgnoreCase("4")) {
            return BUS_4;
        }
        if (bus.equalsIgnoreCase("5")) {
            return BUS_5;
        }
        if (bus.equalsIgnoreCase("6")) {
            return BUS_6;
        }
        return Spi.DEFAULT_BUS;
    }
}

