/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.spi.impl;

import com.pi4j.io.impl.IOAddressConfigBase;
import com.pi4j.io.spi.Spi;
import com.pi4j.io.spi.SpiBus;
import com.pi4j.io.spi.SpiChipSelect;
import com.pi4j.io.spi.SpiConfig;
import com.pi4j.io.spi.SpiMode;
import com.pi4j.util.StringUtil;
import java.util.Map;

public class DefaultSpiConfig
extends IOAddressConfigBase<SpiConfig>
implements SpiConfig {
    protected final Integer baud;
    protected final SpiMode mode;
    protected boolean modeUserProvided = false;
    protected final SpiBus bus;
    protected boolean busUserProvided = false;
    protected final Long flags;
    protected final int readLsbFirst;
    protected final int writeLsbFirst;
    protected boolean readLsbFirstUserProvided;
    protected boolean writeLsbFirstUserProvided;

    protected DefaultSpiConfig(Map<String, String> properties) {
        super(properties);
        this.baud = properties.containsKey("baud") ? Integer.valueOf(StringUtil.parseInteger(properties.get("baud"), 1000000)) : Integer.valueOf(1000000);
        if (properties.containsKey("bus")) {
            this.bus = SpiBus.parse(properties.get("bus"));
            this.busUserProvided = true;
        } else {
            this.bus = Spi.DEFAULT_BUS;
            this.busUserProvided = false;
        }
        if (properties.containsKey("write_lsb")) {
            this.writeLsbFirst = StringUtil.parseInteger(properties.get("write_lsb"), 0);
            this.writeLsbFirstUserProvided = true;
        } else {
            this.writeLsbFirst = 0;
            this.writeLsbFirstUserProvided = false;
        }
        if (properties.containsKey("read_lsb")) {
            this.readLsbFirst = StringUtil.parseInteger(properties.get("read_lsb"), 0);
            this.readLsbFirstUserProvided = true;
        } else {
            this.readLsbFirst = 0;
            this.readLsbFirstUserProvided = false;
        }
        if (properties.containsKey("mode")) {
            this.mode = SpiMode.parse(properties.get("mode"));
            this.modeUserProvided = true;
        } else {
            this.mode = Spi.DEFAULT_MODE;
            this.modeUserProvided = false;
        }
        this.flags = properties.containsKey("flags") ? Long.valueOf(StringUtil.parseLong(properties.get("flags"), null)) : null;
        this.id = StringUtil.setIfNullOrEmpty(this.id, "SPI-" + this.address(), true);
        this.name = StringUtil.setIfNullOrEmpty(this.name, "SPI-" + this.address(), true);
        this.description = StringUtil.setIfNullOrEmpty(this.description, "SPI-" + this.address(), true);
    }

    @Override
    public Integer baud() {
        return this.baud;
    }

    @Override
    public Integer readLsbFirst() {
        return this.readLsbFirst;
    }

    @Override
    public Integer writeLsbFirst() {
        return this.writeLsbFirst;
    }

    @Override
    public boolean busUserProvided() {
        return this.busUserProvided;
    }

    @Override
    public boolean writeLsbFirstUserProvided() {
        return this.writeLsbFirstUserProvided;
    }

    @Override
    public boolean readLsbFirstUserProvided() {
        return this.readLsbFirstUserProvided;
    }

    @Override
    public boolean modeUserProvided() {
        return this.modeUserProvided;
    }

    @Override
    public SpiBus bus() {
        return this.bus;
    }

    @Override
    public SpiMode mode() {
        return this.mode;
    }

    @Override
    public Long flags() {
        return this.flags;
    }

    @Override
    public Integer channel() {
        return this.address();
    }

    @Override
    public SpiChipSelect chipSelect() {
        return SpiChipSelect.getByNumber(this.address());
    }
}

