/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.datareader;

import com.pi4j.boardinfo.util.command.CommandResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuInfoReader {
    private static final Logger logger = LoggerFactory.getLogger(CpuInfoReader.class);
    private static String cpuInfoFilePath = "/proc/cpuinfo";

    public static void setCpuInfoFilePath(String path) {
        cpuInfoFilePath = path;
    }

    public static CommandResult getCpuRevision() {
        String outputMessage = "";
        Object errorMessage = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(cpuInfoFilePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("Revision")) continue;
                String[] parts = line.split(":");
                if (parts.length > 1) {
                    outputMessage = parts[1].trim();
                }
                break;
            }
        }
        catch (IOException ex) {
            errorMessage = "IOException: " + ex.getMessage();
            logger.error("Failed to read the CPU revision from '{}': {}", (Object)cpuInfoFilePath, errorMessage);
        }
        if (!((String)errorMessage).isEmpty() || outputMessage.isEmpty()) {
            return CommandResult.failure((String)(((String)errorMessage).isEmpty() ? "CPU revision not found in file" : errorMessage));
        }
        return CommandResult.success(outputMessage);
    }
}

