/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.definition;

import com.pi4j.boardinfo.definition.BoardType;
import com.pi4j.boardinfo.definition.Cpu;
import com.pi4j.boardinfo.definition.HeaderVersion;
import com.pi4j.boardinfo.definition.PiModel;
import com.pi4j.boardinfo.definition.Soc;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BoardModel {
    MODEL_1_A("Raspberry Pi 1 Model A", BoardType.SINGLE_BOARD_COMPUTER, List.of("0007", "0008", "0009"), PiModel.MODEL_A, HeaderVersion.TYPE_1, LocalDate.of(2013, 2, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(700)), List.of(Integer.valueOf(262144))),
    MODEL_1_A_PLUS("Raspberry Pi 1 Model A+", BoardType.SINGLE_BOARD_COMPUTER, List.of("0012", "0015", "900021"), PiModel.MODEL_A, HeaderVersion.TYPE_1, LocalDate.of(2014, 11, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(700)), List.of(Integer.valueOf(262144), Integer.valueOf(524288)), List.of("Amount of memory changed to 512Mb on 20160810"), false),
    MODEL_3_A_PLUS("Raspberry Pi 3 Model A+", BoardType.SINGLE_BOARD_COMPUTER, List.of("9020e0", "9020e1"), PiModel.MODEL_A, HeaderVersion.TYPE_3, LocalDate.of(2018, 11, 1), Soc.BCM2837B0, Cpu.CORTEX_A53, 4, List.of(Integer.valueOf(1400)), List.of(Integer.valueOf(524288)), new ArrayList<String>(), false),
    MODEL_1_B("Raspberry Pi 1 Model B", BoardType.SINGLE_BOARD_COMPUTER, List.of("0002", "0003", "0004", "0005", "0006", "000d", "000e", "000f"), PiModel.MODEL_B, HeaderVersion.TYPE_1, LocalDate.of(2012, 4, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(700)), List.of(Integer.valueOf(262144), Integer.valueOf(524288)), List.of("Amount of memory changed to 512Mb on 20121015"), false),
    MODEL_1_B_PLUS("Raspberry Pi 1 Model B+", BoardType.SINGLE_BOARD_COMPUTER, List.of("0010", "0013", "900032"), PiModel.MODEL_B, HeaderVersion.TYPE_1, LocalDate.of(2014, 7, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(700)), List.of(Integer.valueOf(524288))),
    MODEL_2_B("Raspberry Pi 2 Model B", BoardType.SINGLE_BOARD_COMPUTER, List.of("a01040", "a01041", "a21041"), PiModel.MODEL_B, HeaderVersion.TYPE_2, LocalDate.of(2015, 2, 1), Soc.BCM2836, Cpu.CORTEX_A7, 4, List.of(Integer.valueOf(900)), List.of(Integer.valueOf(0x100000))),
    MODEL_2_B_V1_2("Raspberry Pi 2 Model B V1.2", BoardType.SINGLE_BOARD_COMPUTER, List.of("a02042", "a22042"), PiModel.MODEL_B, HeaderVersion.TYPE_2, LocalDate.of(2016, 10, 1), Soc.BCM2837, Cpu.CORTEX_A53, 4, List.of(Integer.valueOf(900)), List.of(Integer.valueOf(0x100000))),
    MODEL_3_B("Raspberry Pi 3 Model B", BoardType.SINGLE_BOARD_COMPUTER, List.of("a02082", "a22082", "a32082", "a52082", "a22083"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2016, 2, 1), Soc.BCM2837, Cpu.CORTEX_A53, 4, List.of(Integer.valueOf(1200)), List.of(Integer.valueOf(0x100000))),
    MODEL_3_B_PLUS("Raspberry Pi 3 Model B+", BoardType.SINGLE_BOARD_COMPUTER, List.of("a020d3", "a020d4"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2018, 3, 14), Soc.BCM2837B0, Cpu.CORTEX_A53, 4, List.of(Integer.valueOf(1400)), List.of(Integer.valueOf(0x100000))),
    MODEL_4_B("Raspberry Pi 4 Model B", BoardType.SINGLE_BOARD_COMPUTER, List.of("a03111", "b03111", "b03112", "b03114", "b03115", "c03111", "c03112", "c03114", "c03115", "d03114", "d03115"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2019, 6, 24), Soc.BCM2711, Cpu.CORTEX_A72, 4, List.of(Integer.valueOf(1500), Integer.valueOf(1800)), List.of(Integer.valueOf(0x100000), Integer.valueOf(0x200000), Integer.valueOf(0x400000), Integer.valueOf(0x800000))),
    MODEL_400("Raspberry Pi 400", BoardType.ALL_IN_ONE_COMPUTER, List.of("c03130"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2020, 11, 2), Soc.BCM2711C0, Cpu.CORTEX_A72, 4, List.of(Integer.valueOf(1800)), List.of(Integer.valueOf(0x400000))),
    MODEL_5_B("Raspberry Pi 5 Model B", BoardType.SINGLE_BOARD_COMPUTER, List.of("b04170", "c04170", "d04170", "e04171"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2023, 9, 28), Soc.BCM2712, Cpu.CORTEX_A76, 4, List.of(Integer.valueOf(2400)), List.of(Integer.valueOf(0x200000), Integer.valueOf(0x400000), Integer.valueOf(0x800000), Integer.valueOf(0x1000000)), new ArrayList<String>(), true),
    MODEL_500("Raspberry Pi 500", BoardType.ALL_IN_ONE_COMPUTER, List.of("d04190"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2024, 12, 9), Soc.BCM2712, Cpu.CORTEX_A76, 4, List.of(Integer.valueOf(2400)), List.of(Integer.valueOf(0x800000)), List.of("20241209: Confirmed by Jeff Geerling who has evaluation version: d04190."), true),
    COMPUTE_1("Compute Module 1", BoardType.STACK_ON_COMPUTER, List.of("0011", "0014", "900061"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2014, 4, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(700)), List.of(Integer.valueOf(524288))),
    COMPUTE_3("Compute Module 3", BoardType.STACK_ON_COMPUTER, List.of("a020a0", "a220a0"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2017, 1, 1), Soc.BCM2837, Cpu.CORTEX_A53, 4, List.of(Integer.valueOf(1200)), List.of(Integer.valueOf(0x100000))),
    COMPUTE_3_PLUS("Compute Module 3+", BoardType.STACK_ON_COMPUTER, List.of("a02100"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2019, 1, 1), Soc.BCM2837B0, Cpu.CORTEX_A53, 4, List.of(Integer.valueOf(1200)), List.of(Integer.valueOf(0x100000))),
    COMPUTE_4("Compute Module 4", BoardType.STACK_ON_COMPUTER, List.of("a03140", "b03140", "c03140", "d03140", "a03141", "b03141", "c03141", "d03141"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2020, 10, 1), Soc.BCM2711, Cpu.CORTEX_A72, 4, List.of(Integer.valueOf(1500)), List.of(Integer.valueOf(0x100000), Integer.valueOf(0x200000), Integer.valueOf(0x400000), Integer.valueOf(0x800000))),
    COMPUTE_4_SODIMM("Compute Module 4 SODIMM", BoardType.STACK_ON_COMPUTER, new ArrayList<String>(), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2020, 10, 1), Soc.BCM2711, Cpu.CORTEX_A72, 4, List.of(Integer.valueOf(1500)), List.of(Integer.valueOf(0x100000), Integer.valueOf(0x200000), Integer.valueOf(0x400000), Integer.valueOf(0x800000))),
    COMPUTE_5("Compute Module 5", BoardType.STACK_ON_COMPUTER, List.of("a04180", "b04180", "c04180", "d04180"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2024, 11, 27), Soc.BCM2712, Cpu.CORTEX_A76, 4, List.of(Integer.valueOf(2400)), List.of(Integer.valueOf(0x200000), Integer.valueOf(0x400000), Integer.valueOf(0x800000), Integer.valueOf(0x1000000)), List.of("20241127: The board codes are not documented yet with the Compute 5 announcement.", "20241129: Confirmed by Jeff Geerling who has evaluation version: c04180 for the 4Gb version.", "When compared with Compute 4, we can assume the other boards should have be a, b, d.", "Will be further completed or modified when more info is available."), true),
    ZERO_PCB_1_2("Raspberry Pi Zero PCB V1.2", BoardType.SINGLE_BOARD_COMPUTER, List.of("900092", "920092"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2015, 11, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(1000)), List.of(Integer.valueOf(524288))),
    ZERO_PCB_1_3("Raspberry Pi Zero PCB V1.3", BoardType.SINGLE_BOARD_COMPUTER, List.of("900093", "920093"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2016, 5, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(1000)), List.of(Integer.valueOf(524288))),
    ZERO_W("Raspberry Pi Zero W", BoardType.SINGLE_BOARD_COMPUTER, List.of("9000c1"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2017, 2, 28), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, List.of(Integer.valueOf(1000)), List.of(Integer.valueOf(524288))),
    ZERO_V2("Raspberry Pi Zero V2", BoardType.SINGLE_BOARD_COMPUTER, List.of("902120"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2021, 10, 28), Soc.BCM2710A1, Cpu.CORTEX_A53, 4, List.of(Integer.valueOf(1000)), List.of(Integer.valueOf(524288))),
    PICO("Raspberry Pi Pico", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2021, 1, 1), Soc.RP2040, Cpu.CORTEX_MO_PLUS, 1, List.of(Integer.valueOf(133)), List.of(Integer.valueOf(2312))),
    PICO_W("Raspberry Pi Pico W", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2022, 6, 1), Soc.RP2040, Cpu.CORTEX_MO_PLUS, 1, List.of(Integer.valueOf(133)), List.of(Integer.valueOf(2312)), List.of("Same form factor as PICO but with Wi-Fi"), false),
    PICO_2("Raspberry Pi Pico 2", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2024, 8, 8), Soc.RP2350, Cpu.CORTEX_M33, 1, List.of(Integer.valueOf(150)), List.of(Integer.valueOf(4616))),
    PICO_2_W("Raspberry Pi Pico 2 W", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2024, 8, 8), Soc.RP2350, Cpu.CORTEX_M33, 1, List.of(Integer.valueOf(150)), List.of(Integer.valueOf(4616))),
    GENERIC("Generic board compatible with Raspberry Pi 4", BoardType.SINGLE_BOARD_COMPUTER, new ArrayList<String>(), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.now(), Soc.UNKNOWN, Cpu.UNKNOWN, 4, new ArrayList<Integer>(), new ArrayList<Integer>()),
    GENERIC_RP1("Generic board compatible with Raspberry Pi 5", BoardType.SINGLE_BOARD_COMPUTER, new ArrayList<String>(), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.now(), Soc.UNKNOWN, Cpu.UNKNOWN, 4, new ArrayList<Integer>(), new ArrayList<Integer>(), new ArrayList<String>(), true),
    UNKNOWN("Unknown", BoardType.UNKNOWN, new ArrayList<String>(), PiModel.UNKNOWN, HeaderVersion.UNKNOWN, null, Soc.UNKNOWN, Cpu.UNKNOWN, 0, new ArrayList<Integer>(), new ArrayList<Integer>());

    private static final Logger logger;
    private final String label;
    private final BoardType boardType;
    private final List<String> boardCodes;
    private final PiModel model;
    private final HeaderVersion headerVersion;
    private final LocalDate releaseDate;
    private final Soc soc;
    private final Cpu cpu;
    private final Integer numberOfCpu;
    private final List<Integer> versionsProcessorSpeedInMhz;
    private final List<Integer> versionsMemoryInKb;
    private final List<String> remarks;
    private final Boolean usesRP1;

    private BoardModel(String label, BoardType boardType, List<String> boardCodes, PiModel model, HeaderVersion headerVersion, LocalDate releaseDate, Soc soc, Cpu cpu, Integer numberOfCpu, List<Integer> versionsProcessorSpeedInMhz, List<Integer> versionsMemoryInKb) {
        this(label, boardType, boardCodes, model, headerVersion, releaseDate, soc, cpu, numberOfCpu, versionsProcessorSpeedInMhz, versionsMemoryInKb, new ArrayList<String>(), false);
    }

    private BoardModel(String label, BoardType boardType, List<String> boardCodes, PiModel model, HeaderVersion headerVersion, LocalDate releaseDate, Soc soc, Cpu cpu, Integer numberOfCpu, List<Integer> versionsProcessorSpeedInMhz, List<Integer> versionsMemoryInKb, List<String> remarks, Boolean usesRP1) {
        this.label = label;
        this.boardType = boardType;
        this.boardCodes = boardCodes;
        this.model = model;
        this.headerVersion = headerVersion;
        this.releaseDate = releaseDate;
        this.soc = soc;
        this.cpu = cpu;
        this.numberOfCpu = numberOfCpu;
        this.versionsProcessorSpeedInMhz = versionsProcessorSpeedInMhz;
        this.versionsMemoryInKb = versionsMemoryInKb;
        this.remarks = remarks;
        this.usesRP1 = usesRP1;
    }

    public static BoardModel getByBoardCode(String boardCode) throws Exception {
        List matches = Arrays.stream(BoardModel.values()).filter(bm -> bm.boardCodes.contains(boardCode)).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return UNKNOWN;
        }
        if (matches.size() > 1) {
            throw new Exception("Too many matching models found for code " + boardCode);
        }
        return (BoardModel)((Object)matches.get(0));
    }

    public static BoardModel getByBoardName(String boardName) {
        List matches = Arrays.stream(BoardModel.values()).filter(bm -> boardName.toLowerCase().startsWith(bm.label.toLowerCase())).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return UNKNOWN;
        }
        if (matches.size() > 1) {
            logger.error("Too many matching models found for name {}, the given name is not exclusive enough", (Object)boardName);
        }
        return (BoardModel)((Object)matches.get(0));
    }

    public static List<String> getAllBoardCodes() {
        return Arrays.stream(BoardModel.values()).flatMap(b -> b.boardCodes.stream()).collect(Collectors.toList());
    }

    public String getName() {
        return this.name();
    }

    public String getLabel() {
        return this.label;
    }

    public BoardType getBoardType() {
        return this.boardType;
    }

    public List<String> getBoardCodes() {
        return this.boardCodes;
    }

    public PiModel getModel() {
        return this.model;
    }

    public HeaderVersion getHeaderVersion() {
        return this.headerVersion;
    }

    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    public Soc getSoc() {
        return this.soc;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Integer getNumberOfCpu() {
        return this.numberOfCpu;
    }

    public List<Integer> getVersionsProcessorSpeedInMhz() {
        return this.versionsProcessorSpeedInMhz;
    }

    public List<Integer> getVersionsMemoryInKb() {
        return this.versionsMemoryInKb;
    }

    public List<Float> getVersionsMemoryInMb() {
        return this.versionsMemoryInKb.stream().map(m -> Float.valueOf((float)m.intValue() / 1024.0f)).collect(Collectors.toList());
    }

    public List<Float> getVersionsMemoryInGb() {
        return this.versionsMemoryInKb.stream().map(m -> Float.valueOf((float)m.intValue() / 1024.0f / 1024.0f)).collect(Collectors.toList());
    }

    public List<String> getRemarks() {
        return this.remarks;
    }

    public boolean usesRP1() {
        return this.usesRP1;
    }

    static {
        logger = LoggerFactory.getLogger(BoardModel.class);
    }
}

