/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.util;

import com.pi4j.boardinfo.datareader.BoardCodeReader;
import com.pi4j.boardinfo.datareader.CpuInfoReader;
import com.pi4j.boardinfo.datareader.MemInfoReader;
import com.pi4j.boardinfo.definition.BoardModel;
import com.pi4j.boardinfo.model.BoardInfo;
import com.pi4j.boardinfo.model.BoardReading;
import com.pi4j.boardinfo.model.JavaInfo;
import com.pi4j.boardinfo.model.JvmMemory;
import com.pi4j.boardinfo.model.OperatingSystem;
import com.pi4j.boardinfo.util.command.CommandExecutor;
import com.pi4j.boardinfo.util.command.CommandResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardInfoHelper {
    private static final Logger logger = LoggerFactory.getLogger(BoardInfoHelper.class);
    private final BoardInfo boardInfo;

    private BoardInfoHelper() {
        OperatingSystem os = new OperatingSystem(System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        logger.info("Detected OS: {}", (Object)os);
        JavaInfo java = new JavaInfo(System.getProperty("java.version"), System.getProperty("java.runtime.version"), System.getProperty("java.vendor"), System.getProperty("java.vendor.version"));
        logger.info("Detected Java: {}", (Object)java);
        this.boardInfo = this.detectBoardInfo(os, java);
    }

    public void setBoardModel(BoardModel boardModel) {
        this.boardInfo.setBoardModel(boardModel);
    }

    public static BoardInfo current() {
        return SingletonHelper.INSTANCE.boardInfo;
    }

    public static synchronized void reinitialize() {
        logger.info("Reinitializing BoardInfoHelper singleton instance.");
        SingletonHelper.resetInstance();
    }

    private BoardInfo detectBoardInfo(OperatingSystem os, JavaInfo java) {
        String boardVersionCode = BoardInfoHelper.getBoardVersionCode();
        try {
            BoardModel boardModelByBoardCode = BoardModel.getByBoardCode(boardVersionCode);
            if (boardModelByBoardCode != BoardModel.UNKNOWN) {
                logger.info("Detected board type {} by code: {}", (Object)boardModelByBoardCode.name(), (Object)boardVersionCode);
                return new BoardInfo(boardModelByBoardCode, os, java);
            }
        }
        catch (Exception e) {
            logger.warn("Could not detect the board type for code {}: {}", (Object)boardVersionCode, (Object)e.getMessage());
        }
        String boardName = BoardInfoHelper.getBoardName();
        BoardModel boardModelByBoardName = BoardModel.getByBoardName(boardName);
        if (boardModelByBoardName != BoardModel.UNKNOWN) {
            logger.info("Detected board type {} by name: {}", (Object)boardModelByBoardName.name(), (Object)boardName);
            return new BoardInfo(boardModelByBoardName, os, java);
        }
        logger.warn("Sorry, could not detect the board type");
        return new BoardInfo(BoardModel.UNKNOWN, os, java);
    }

    public static boolean usesRP1() {
        return BoardInfoHelper.current().getBoardModel().usesRP1();
    }

    public static boolean runningOnRaspberryPi() {
        return BoardInfoHelper.current().getBoardModel() != BoardModel.UNKNOWN;
    }

    public static boolean is32bit() {
        return !BoardInfoHelper.is64bit();
    }

    public static boolean is64bit() {
        return System.getProperty("sun.arch.data.model").equals("64");
    }

    public static String getBoardVersionCode() {
        CommandResult output = CpuInfoReader.getCpuRevision();
        if (output.isSuccess()) {
            return output.getOutputMessage();
        }
        logger.error("Could not get the board version code: {}", (Object)output.getErrorMessage());
        return "";
    }

    public static String getBoardName() {
        CommandResult output = BoardCodeReader.getBoardCode();
        if (output.isSuccess()) {
            return output.getOutputMessage();
        }
        logger.error("Could not get the board name: {}", (Object)output.getErrorMessage());
        return "";
    }

    public static JvmMemory getJvmMemory() {
        return new JvmMemory(Runtime.getRuntime());
    }

    public static BoardReading getBoardReading() {
        return new BoardReading(BoardInfoHelper.getBoardName(), BoardInfoHelper.getBoardVersionCode(), BoardInfoHelper.getTemperature(), BoardInfoHelper.getUptime(), BoardInfoHelper.getCoreVoltage(), BoardInfoHelper.getMemTotal(), BoardInfoHelper.getThrottledState());
    }

    private static String getMemTotal() {
        return MemInfoReader.getMemTotal().getOutputMessage();
    }

    private static String getCoreVoltage() {
        return CommandExecutor.execute("vcgencmd measure_volts").getOutputMessage();
    }

    private static String getUptime() {
        return CommandExecutor.execute("uptime").getOutputMessage();
    }

    private static String getTemperature() {
        return CommandExecutor.execute("vcgencmd measure_temp").getOutputMessage();
    }

    public static String getThrottledState() {
        return CommandExecutor.execute("vcgencmd get_throttled").getOutputMessage();
    }

    private static class SingletonHelper {
        private static volatile BoardInfoHelper INSTANCE = new BoardInfoHelper();

        private SingletonHelper() {
        }

        private static synchronized void resetInstance() {
            INSTANCE = new BoardInfoHelper();
        }
    }
}

