/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.runtime.impl;

import com.pi4j.context.Context;
import com.pi4j.runtime.RuntimeProperties;
import com.pi4j.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntimeProperties
implements RuntimeProperties {
    public static String PI4J_PROPERTIES_FILE_NAME = "pi4j.properties";
    protected Map<String, String> properties = Collections.synchronizedMap(new HashMap());
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static RuntimeProperties newInstance(Context context) {
        return new DefaultRuntimeProperties(context);
    }

    private DefaultRuntimeProperties(Context context) {
        Properties p;
        Path appFile;
        try {
            Map<String, String> envars = System.getenv();
            envars.keySet().stream().filter(key -> key.toUpperCase().startsWith("PI4J_")).forEach(key -> {
                String k = key.substring(5).replace('_', '.').toLowerCase();
                String v = (String)envars.get(key);
                this.put(k, v);
            });
            this.put(System.getenv(), "pi4j.");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            appFile = Paths.get("/etc/pi4j", PI4J_PROPERTIES_FILE_NAME);
            if (Files.exists(appFile, new LinkOption[0])) {
                p = new Properties();
                p.load(new FileInputStream(appFile.toFile()));
                this.put(p);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            appFile = Paths.get(System.getProperty("user.home"), "." + PI4J_PROPERTIES_FILE_NAME);
            if (Files.exists(appFile, new LinkOption[0])) {
                p = new Properties();
                p.load(new FileInputStream(appFile.toFile()));
                this.put(p);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            appFile = Paths.get(System.getProperty("user.dir"), PI4J_PROPERTIES_FILE_NAME);
            if (Files.exists(appFile, new LinkOption[0])) {
                p = new Properties();
                p.load(new FileInputStream(appFile.toFile()));
                this.put(p);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            File resourceFile;
            URL resource = this.getClass().getClassLoader().getResource(PI4J_PROPERTIES_FILE_NAME);
            if (resource != null && (resourceFile = new File(resource.getFile())) != null && resourceFile.exists()) {
                Properties p2 = new Properties();
                p2.load(new FileInputStream(resourceFile));
                this.put(p2);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.put(System.getProperties(), "pi4j.");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.put(context.config().properties());
    }

    protected String sanitizeKey(String key) {
        return key.trim().toLowerCase();
    }

    @Override
    public boolean has(String key) {
        return this.properties.containsKey(this.sanitizeKey(key));
    }

    @Override
    public String get(String key) {
        String k = this.sanitizeKey(key);
        if (this.properties.containsKey(k)) {
            return this.properties.get(k);
        }
        return null;
    }

    @Override
    public void put(String key, String value) {
        this.properties.put(this.sanitizeKey(key), value);
    }

    @Override
    public void put(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.properties.put(this.sanitizeKey(key.toString()), value.toString())));
    }

    @Override
    public void put(Map<String, String> values) {
        values.forEach((key, value) -> this.properties.put(this.sanitizeKey((String)key), (String)value));
    }

    @Override
    public void put(Map.Entry<String, String> ... value) {
        for (Map.Entry<String, String> e : value) {
            this.properties.put(this.sanitizeKey(e.getKey().toString()), e.getValue().toString());
        }
    }

    @Override
    public Map<String, String> all() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public int count() {
        return this.properties.size();
    }

    protected void put(Properties properties, String prefixFilter) {
        Map<String, String> entries = properties.keySet().stream().collect(Collectors.toMap(k -> k.toString(), key -> properties.get(key).toString()));
        this.put(entries, prefixFilter);
    }

    protected void put(Map<String, String> properties, String prefixFilter) {
        if (StringUtil.isNullOrEmpty(prefixFilter)) {
            this.put(properties);
            return;
        }
        Object prefix = prefixFilter.endsWith(".") ? prefixFilter : prefixFilter + ".";
        properties.keySet().stream().filter(arg_0 -> DefaultRuntimeProperties.lambda$put$4((String)prefix, arg_0)).forEach(arg_0 -> this.lambda$put$5((String)prefix, properties, arg_0));
    }

    private /* synthetic */ void lambda$put$5(String prefix, Map properties, String key) {
        this.put(key.substring(prefix.length()), (String)properties.get(key));
    }

    private static /* synthetic */ boolean lambda$put$4(String prefix, String key) {
        return key.startsWith(prefix);
    }
}

