/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.gyroscope.honeywell;

import com.pi4j.component.gyroscope.AxisGyroscope;
import com.pi4j.component.gyroscope.Gyroscope;
import com.pi4j.component.gyroscope.MultiAxisGyro;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class HMC5883L
implements MultiAxisGyro {
    public static final int HMC5883L_ADDRESS = 30;
    private I2CDevice device;
    public final Gyroscope X = new AxisGyroscope(this, 20.0f);
    public final Gyroscope Y = new AxisGyroscope(this, 20.0f);
    public final Gyroscope Z = new AxisGyroscope(this, 20.0f);
    protected final AxisGyroscope aX = (AxisGyroscope)this.X;
    protected final AxisGyroscope aY = (AxisGyroscope)this.Y;
    protected final AxisGyroscope aZ = (AxisGyroscope)this.Z;
    private int timeDelta;
    private long lastRead;
    private static final int CALIBRATION_READS = 50;
    private static final int CALIBRATION_SKIPS = 5;
    public static final int OUTPUT_RATE_0_75_Hz = 0;
    public static final int OUTPUT_RATE_1_5_Hz = 1;
    public static final int OUTPUT_RATE_3_Hz = 2;
    public static final int OUTPUT_RATE_7_5_Hz = 3;
    public static final int OUTPUT_RATE_15_Hz = 4;
    public static final int OUTPUT_RATE_30_Hz = 5;
    public static final int OUTPUT_RATE_75_Hz = 6;
    public static final int SAMPLES_AVERAGE_1 = 0;
    public static final int SAMPLES_AVERAGE_2 = 1;
    public static final int SAMPLES_AVERAGE_4 = 2;
    public static final int SAMPLES_AVERAGE_8 = 3;
    public static final int NORMAL_MEASUREMENT_MODE = 0;
    public static final int POSITIVE_BIAS_MEASUREMENT_MODE = 1;
    public static final int NEGATIVE_BIAS_MEASUREMENT_MODE = 2;
    public static final int GAIN_0_88_Ga = 0;
    public static final int GAIN_1_3_Ga = 1;
    public static final int GAIN_1_9_Ga = 2;
    public static final int GAIN_2_5_Ga = 3;
    public static final int GAIN_4_0_Ga = 4;
    public static final int GAIN_4_7_Ga = 5;
    public static final int GAIN_5_6_Ga = 6;
    public static final int GAIN_8_1_Ga = 7;
    public static final int CONINIOUS_MODE = 0;
    public static final int SINGLE_SAMPLE_MODE = 1;
    public static final int IDLE_MODE = 2;
    private int outputRate = 4;
    private int samplesAverage = 3;
    private int measurementMode = 0;
    private int gain = 1;
    private int mode = 0;

    public HMC5883L(I2CBus bus) throws IOException {
        this.device = bus.getDevice(30);
    }

    public int getOutputRate() {
        return this.outputRate;
    }

    public void setOutputRate(int outputRate) {
        this.outputRate = outputRate;
    }

    public int getSamplesAverage() {
        return this.samplesAverage;
    }

    public void setSamplesAverage(int samplesAverage) {
        this.samplesAverage = samplesAverage;
    }

    public int getMeasurementMode() {
        return this.measurementMode;
    }

    public void setMeasurementMode(int measurementMode) {
        this.measurementMode = measurementMode;
    }

    public int getGain() {
        return this.gain;
    }

    public void setGain(int gain) {
        this.gain = gain;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public Gyroscope init(Gyroscope triggeringAxis, int triggeringMode) throws IOException {
        this.enable();
        if (triggeringAxis == this.aX) {
            this.aX.setReadTrigger(triggeringMode);
        } else {
            this.aX.setReadTrigger(0);
        }
        if (triggeringAxis == this.aY) {
            this.aY.setReadTrigger(triggeringMode);
        } else {
            this.aY.setReadTrigger(0);
        }
        if (triggeringAxis == this.aZ) {
            this.aZ.setReadTrigger(triggeringMode);
        } else {
            this.aZ.setReadTrigger(0);
        }
        return triggeringAxis;
    }

    @Override
    public void enable() throws IOException {
        this.device.write(2, (byte)0);
    }

    @Override
    public void disable() throws IOException {
        byte[] init = new byte[]{(byte)((this.samplesAverage << 5) + (this.outputRate << 2) + this.measurementMode), (byte)(this.gain << 5), 2};
        this.device.write(0, init, 0, 3);
    }

    @Override
    public void readGyro() throws IOException {
        long now = System.currentTimeMillis();
        this.timeDelta = (int)(now - this.lastRead);
        this.lastRead = now;
        byte[] data = new byte[6];
        int r = this.device.read(3, data, 0, 6);
        if (r != 6) {
            throw new IOException("Couldn't read compass data; r=" + r);
        }
        int x = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
        int y = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
        int z = ((data[3] & 0xFF) << 8) + (data[5] & 0xFF);
        this.aX.setRawValue(x);
        this.aY.setRawValue(y);
        this.aZ.setRawValue(z);
    }

    @Override
    public int getTimeDelta() {
        return this.timeDelta;
    }

    @Override
    public void recalibrateOffset() throws IOException {
        int i;
        long totalX = 0L;
        long totalY = 0L;
        long totalZ = 0L;
        int minX = 10000;
        int minY = 10000;
        int minZ = 10000;
        int maxX = -10000;
        int maxY = -10000;
        int maxZ = -10000;
        for (i = 0; i < 5; ++i) {
            this.readGyro();
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (i = 0; i < 50; ++i) {
            this.readGyro();
            int x = this.aX.getRawValue();
            int y = this.aY.getRawValue();
            int z = this.aZ.getRawValue();
            totalX += (long)x;
            totalY += (long)y;
            totalZ += (long)z;
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        this.aX.setOffset((int)(totalX / 50L));
        this.aY.setOffset((int)(totalY / 50L));
        this.aZ.setOffset((int)(totalZ / 50L));
    }

    public static void main(String[] args) throws Exception {
        I2CBus bus = I2CFactory.getInstance((int)0);
        HMC5883L hmc5883l = new HMC5883L(bus);
        hmc5883l.init(hmc5883l.X, 4);
        long now = System.currentTimeMillis();
        int measurement = 0;
        while (System.currentTimeMillis() - now < 10000L) {
            String sm = HMC5883L.toString(measurement, 3);
            String sx = HMC5883L.toString(hmc5883l.X.getRawValue(), 7);
            String sy = HMC5883L.toString(hmc5883l.Y.getRawValue(), 7);
            String sz = HMC5883L.toString(hmc5883l.Z.getRawValue(), 7);
            System.out.print(sm + sx + sy + sz);
            for (int i = 0; i < 24; ++i) {
                System.out.print('\b');
            }
            Thread.sleep(100L);
            ++measurement;
        }
        System.out.println();
    }

    public static String toString(int i, int l) {
        String s = Integer.toString(i);
        return "        ".substring(0, l - s.length()) + s;
    }
}

