/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.fireplace;

import com.pi4j.device.DeviceListener;
import com.pi4j.device.ObserveableDeviceBase;
import com.pi4j.device.fireplace.Fireplace;
import com.pi4j.device.fireplace.FireplacePilotLightEvent;
import com.pi4j.device.fireplace.FireplacePilotLightException;
import com.pi4j.device.fireplace.FireplacePilotLightListener;
import com.pi4j.device.fireplace.FireplaceState;
import com.pi4j.device.fireplace.FireplaceStateChangeEvent;
import com.pi4j.device.fireplace.FireplaceStateChangeListener;
import com.pi4j.device.fireplace.FireplaceTimeoutEvent;
import com.pi4j.device.fireplace.FireplaceTimeoutListener;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class FireplaceBase
extends ObserveableDeviceBase
implements Fireplace {
    protected long timeoutDelay = 0L;
    protected Future timeoutTask = null;
    protected TimeUnit timeoutUnit = TimeUnit.MINUTES;
    protected ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public FireplaceBase() {
        this.addListener(new FireplaceStateChangeListener(){

            @Override
            public void onStateChange(FireplaceStateChangeEvent event) {
                FireplaceBase.this.cancelTimeoutTask();
            }
        });
    }

    @Override
    public boolean isOn() {
        return this.getState() == FireplaceState.ON;
    }

    @Override
    public boolean isOff() {
        return this.getState() == FireplaceState.OFF;
    }

    @Override
    public abstract FireplaceState getState();

    @Override
    public boolean isState(FireplaceState state) {
        return this.getState().equals((Object)state);
    }

    @Override
    public void addListener(FireplaceStateChangeListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(FireplaceStateChangeListener ... listener) {
        super.removeListener(listener);
    }

    @Override
    public void addListener(FireplacePilotLightListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(FireplacePilotLightListener ... listener) {
        super.removeListener(listener);
    }

    @Override
    public void addListener(FireplaceTimeoutListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(FireplaceTimeoutListener ... listener) {
        super.removeListener(listener);
    }

    @Override
    public void on() throws FireplacePilotLightException {
        this.setState(FireplaceState.ON);
    }

    @Override
    public void off() {
        try {
            this.setState(FireplaceState.OFF);
        }
        catch (FireplacePilotLightException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void on(long timeoutDelay, TimeUnit timeoutUnit) throws FireplacePilotLightException {
        this.on();
        this.setTimeout(timeoutDelay, timeoutUnit);
    }

    @Override
    public void cancelTimeout() {
        this.cancelTimeoutTask();
    }

    @Override
    public void setTimeout(long delay, TimeUnit unit) {
        if (this.isOff()) {
            throw new RuntimeException("Unable to set timeout when fireplace is off.");
        }
        this.timeoutDelay = delay;
        this.timeoutUnit = unit;
        this.cancelTimeoutTask();
        if (this.timeoutDelay > 0L) {
            this.timeoutTask = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    FireplaceTimeoutEvent event = new FireplaceTimeoutEvent(FireplaceBase.this);
                    FireplaceBase.this.notifyListeners(event);
                    if (!event.isHandled()) {
                        FireplaceBase.this.off();
                    }
                }
            }, this.timeoutDelay, this.timeoutUnit);
        }
    }

    @Override
    public long getTimeoutDelay() {
        return this.timeoutDelay;
    }

    @Override
    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    protected synchronized void notifyListeners(FireplaceStateChangeEvent event) {
        for (DeviceListener listener : this.listeners) {
            if (!(listener instanceof FireplaceStateChangeListener)) continue;
            ((FireplaceStateChangeListener)listener).onStateChange(event);
        }
    }

    protected synchronized void notifyListeners(FireplacePilotLightEvent event) {
        for (DeviceListener listener : this.listeners) {
            if (!(listener instanceof FireplacePilotLightListener)) continue;
            ((FireplacePilotLightListener)listener).onChange(event);
        }
    }

    protected synchronized void notifyListeners(FireplaceTimeoutEvent event) {
        for (DeviceListener listener : this.listeners) {
            if (!(listener instanceof FireplaceTimeoutListener)) continue;
            ((FireplaceTimeoutListener)listener).onTimeout(event);
        }
    }

    protected void cancelTimeoutTask() {
        if (this.timeoutTask != null) {
            if (!this.timeoutTask.isDone() && !this.timeoutTask.isCancelled()) {
                this.timeoutTask.cancel(true);
            }
            this.timeoutTask = null;
        }
    }

    @Override
    public void shutdown() {
        this.cancelTimeoutTask();
        this.off();
        this.executor.shutdown();
    }
}

