/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component;

import com.pi4j.component.ComponentBase;
import com.pi4j.component.ComponentListener;
import com.pi4j.component.ObserveableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ObserveableComponentBase
extends ComponentBase
implements ObserveableComponent {
    protected final List<ComponentListener> listeners = new ArrayList<ComponentListener>();

    protected synchronized void addListener(ComponentListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        Collections.addAll(this.listeners, listener);
    }

    protected synchronized void removeListener(ComponentListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (ComponentListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        ArrayList<ComponentListener> listeners_copy = new ArrayList<ComponentListener>(this.listeners);
        for (int index = listeners_copy.size() - 1; index >= 0; --index) {
            ComponentListener listener = (ComponentListener)listeners_copy.get(index);
            this.removeListener(listener);
        }
    }
}

