/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.gyroscope;

import com.pi4j.component.gyroscope.Gyroscope;
import com.pi4j.component.gyroscope.MultiAxisGyro;
import java.io.IOException;

public class AxisGyroscope
implements Gyroscope {
    private MultiAxisGyro multiAxisGyro;
    private int trigger;
    private int value;
    private int offset;
    private float angle;
    private float degPerSecondFactor;
    private boolean factorSet = false;

    public AxisGyroscope(MultiAxisGyro multiAxisGyro) {
        this.multiAxisGyro = multiAxisGyro;
    }

    public AxisGyroscope(MultiAxisGyro multiAxisGyro, float degPerSecondFactor) {
        this.multiAxisGyro = multiAxisGyro;
        this.degPerSecondFactor = degPerSecondFactor;
        this.factorSet = true;
    }

    @Override
    public void setRawValue(int value) {
        this.value = value;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void setReadTrigger(int trigger) {
        this.trigger = trigger;
    }

    protected float readAndUpdateAngle() throws IOException {
        this.multiAxisGyro.readGyro();
        int adjusted = (this.value - this.offset) / 40 * 40;
        float angularVelocity = this.factorSet ? (float)adjusted / this.degPerSecondFactor : (float)adjusted;
        this.angle += angularVelocity * (float)this.multiAxisGyro.getTimeDelta() / 1000.0f;
        return angularVelocity;
    }

    @Override
    public int getRawValue() throws IOException {
        if (this.trigger == 4) {
            this.readAndUpdateAngle();
        }
        return this.value;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setAngle(float angle) {
        this.angle = angle;
    }

    @Override
    public float getAngle() throws IOException {
        if (this.trigger == 1) {
            this.readAndUpdateAngle();
        }
        return this.angle;
    }

    @Override
    public float getAngularVelocity() throws IOException {
        if (this.trigger == 2) {
            return this.readAndUpdateAngle();
        }
        int adjusted = this.value - this.offset;
        if (this.factorSet) {
            return (float)adjusted / this.degPerSecondFactor;
        }
        return adjusted;
    }

    @Override
    public void recalibrateOffset() throws IOException {
        this.multiAxisGyro.recalibrateOffset();
    }
}

