/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.gyroscope.analogdevices;

import com.pi4j.component.gyroscope.AxisGyroscope;
import com.pi4j.component.gyroscope.Gyroscope;
import com.pi4j.component.gyroscope.MultiAxisGyro;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class ADXL345
implements MultiAxisGyro {
    public static final int ADXL345_ADDRESS = 83;
    private I2CDevice device;
    public final Gyroscope X = new AxisGyroscope(this, 20.0f);
    public final Gyroscope Y = new AxisGyroscope(this, 20.0f);
    public final Gyroscope Z = new AxisGyroscope(this, 20.0f);
    protected final AxisGyroscope aX = (AxisGyroscope)this.X;
    protected final AxisGyroscope aY = (AxisGyroscope)this.Y;
    protected final AxisGyroscope aZ = (AxisGyroscope)this.Z;
    private int timeDelta;
    private long lastRead;
    private static final int CALIBRATION_READS = 50;
    private static final int CALIBRATION_SKIPS = 5;

    public ADXL345(I2CBus bus) throws IOException {
        this.device = bus.getDevice(83);
    }

    @Override
    public Gyroscope init(Gyroscope triggeringAxis, int triggeringMode) throws IOException {
        this.enable();
        if (triggeringAxis == this.aX) {
            this.aX.setReadTrigger(triggeringMode);
        } else {
            this.aX.setReadTrigger(0);
        }
        if (triggeringAxis == this.aY) {
            this.aY.setReadTrigger(triggeringMode);
        } else {
            this.aY.setReadTrigger(0);
        }
        if (triggeringAxis == this.aZ) {
            this.aZ.setReadTrigger(triggeringMode);
        } else {
            this.aZ.setReadTrigger(0);
        }
        return triggeringAxis;
    }

    @Override
    public void enable() throws IOException {
        this.device.write(49, (byte)11);
    }

    @Override
    public void disable() throws IOException {
    }

    @Override
    public void readGyro() throws IOException {
        long now = System.currentTimeMillis();
        this.timeDelta = (int)(now - this.lastRead);
        this.lastRead = now;
        byte[] data = new byte[6];
        this.device.write(45, (byte)8);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int r = this.device.read(50, data, 0, 6);
        if (r != 6) {
            throw new IOException("Couldn't read compass data; r=" + r);
        }
        int x = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
        int y = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
        int z = ((data[3] & 0xFF) << 8) + (data[5] & 0xFF);
        this.aX.setRawValue(x);
        this.aY.setRawValue(y);
        this.aZ.setRawValue(z);
    }

    @Override
    public int getTimeDelta() {
        return this.timeDelta;
    }

    @Override
    public void recalibrateOffset() throws IOException {
        int i;
        long totalX = 0L;
        long totalY = 0L;
        long totalZ = 0L;
        int minX = 10000;
        int minY = 10000;
        int minZ = 10000;
        int maxX = -10000;
        int maxY = -10000;
        int maxZ = -10000;
        for (i = 0; i < 5; ++i) {
            this.readGyro();
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (i = 0; i < 50; ++i) {
            this.readGyro();
            int x = this.aX.getRawValue();
            int y = this.aY.getRawValue();
            int z = this.aZ.getRawValue();
            totalX += (long)x;
            totalY += (long)y;
            totalZ += (long)z;
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        this.aX.setOffset((int)(totalX / 50L));
        this.aY.setOffset((int)(totalY / 50L));
        this.aZ.setOffset((int)(totalZ / 50L));
    }

    public static void main(String[] args) throws Exception {
        I2CBus bus = I2CFactory.getInstance((int)1);
        ADXL345 adxl345 = new ADXL345(bus);
        adxl345.init(adxl345.X, 4);
        long now = System.currentTimeMillis();
        int measurement = 0;
        while (System.currentTimeMillis() - now < 10000L) {
            adxl345.readGyro();
            String sm = ADXL345.toString(measurement, 3);
            String sx = ADXL345.toString(adxl345.X.getRawValue(), 7);
            String sy = ADXL345.toString(adxl345.Y.getRawValue(), 7);
            String sz = ADXL345.toString(adxl345.Z.getRawValue(), 7);
            System.out.print(sm + sx + sy + sz);
            for (int i = 0; i < 24; ++i) {
                System.out.print('\b');
            }
            Thread.sleep(100L);
            ++measurement;
        }
        System.out.println();
    }

    public static String toString(int i, int l) {
        String s = Integer.toString(i);
        return "        ".substring(0, l - s.length()) + s;
    }
}

