/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.servo.impl;

import com.pi4j.component.servo.ServoDriver;
import com.pi4j.component.servo.ServoProvider;
import com.pi4j.component.servo.impl.MaestroServoDriver;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.impl.PinImpl;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialFactory;
import com.pi4j.io.serial.SerialPortException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaestroServoProvider
implements ServoProvider {
    public static final String PROVIDER_NAME = "Pololu Maestro Servo Controller";
    public static final String USB_DEVICE = "/dev/ttyACM0";
    public static final String UART_DEVICE = "/dev/ttyAMA0";
    public static final int DEFAULT_DEVICE_ADDRESS = 12;
    public static final int DEFAULT_BAUDRATE = 9600;
    public static Map<Pin, String> PIN_MAP = new HashMap<Pin, String>();
    public static Map<String, Pin> REVERSE_PIN_MAP = new HashMap<String, Pin>();
    protected InterfaceType interfaceType;
    protected Serial device;
    private String deviceName = "undefined";
    private byte deviceAddress;
    protected Map<Pin, MaestroServoDriver> servoDrivers = new HashMap<Pin, MaestroServoDriver>();

    public MaestroServoProvider() throws SerialPortException, IOException {
        this(InterfaceType.UART, -1, 9600);
    }

    public MaestroServoProvider(InterfaceType interfaceType) throws SerialPortException, IOException {
        this(interfaceType, -1, 9600);
    }

    public MaestroServoProvider(InterfaceType interfaceType, int deviceAddress, int baudrate) throws SerialPortException, IOException {
        this.interfaceType = interfaceType;
        if (deviceAddress == -1) {
            deviceAddress = 12;
        }
        this.deviceAddress = (byte)deviceAddress;
        this.deviceName = interfaceType == InterfaceType.USB ? USB_DEVICE : UART_DEVICE;
        this.device = SerialFactory.createInstance();
        this.device.open(this.deviceName, baudrate);
    }

    public void dispose() {
        try {
            if (this.device != null && this.device.isOpen()) {
                this.device.close();
            }
            this.device = null;
            this.servoDrivers.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Pin> getDefinedServoPins() throws IOException {
        ArrayList<Pin> servoPins = new ArrayList<Pin>();
        for (Pin pin : PIN_MAP.keySet()) {
            servoPins.add(pin);
        }
        return servoPins;
    }

    @Override
    public synchronized ServoDriver getServoDriver(Pin servoPin) throws IOException {
        List<Pin> servoPins = this.getDefinedServoPins();
        int index = servoPins.indexOf(servoPin);
        if (index < 0) {
            throw new IOException("Servo driver cannot drive pin " + servoPin);
        }
        MaestroServoDriver driver = this.servoDrivers.get(servoPin);
        if (driver == null) {
            driver = new MaestroServoDriver(this, servoPin);
            this.servoDrivers.put(servoPin, driver);
        }
        return driver;
    }

    public synchronized ServoDriver getServoDriver(int address) throws IOException {
        for (Pin pin : this.getDefinedServoPins()) {
            if (pin.getAddress() != address) continue;
            return this.getServoDriver(pin);
        }
        return null;
    }

    protected synchronized void setServoPosition(int pinAddress, int value) {
        byte[] command = new byte[]{-124, (byte)pinAddress, (byte)(value & 0x7F), (byte)(value >> 7 & 0x7F)};
        this.write(command);
    }

    protected synchronized int getServoPosition(int pinAddress) {
        byte[] command = new byte[]{-112, (byte)pinAddress};
        this.write(command);
        byte[] response = this.read(2);
        return response[0] + 256 * response[1];
    }

    protected void setSpeed(int pinAddress, int value) {
        byte[] command = new byte[]{-121, (byte)pinAddress, (byte)(value & 0x7F), (byte)(value >> 7 & 0x7F)};
        this.write(command);
    }

    protected void setAcceleration(int pinAddress, int value) {
        byte[] command = new byte[]{-119, (byte)pinAddress, (byte)(value & 0x7F), (byte)(value >> 7 & 0x7F)};
        this.write(command);
    }

    protected boolean isMoving() {
        byte[] command = new byte[]{-109};
        this.write(command);
        byte[] response = this.read(1);
        return response[0] == 1;
    }

    protected int getError() {
        byte[] command = new byte[]{-95};
        this.write(command);
        byte[] response = this.read(2);
        return response[1] << 8 | response[0];
    }

    protected void goHome() {
        byte[] command = new byte[]{-94};
        this.write(command);
    }

    private void write(byte[] command) {
        try {
            if (this.interfaceType == InterfaceType.UART) {
                this.device.write(new byte[]{-86, this.deviceAddress});
                command[0] = (byte)(command[0] & 0x7F);
            }
            this.device.write(command);
            this.device.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing to " + this.deviceName, e);
        }
    }

    private byte[] read(int len) {
        byte[] response = new byte[len];
        try {
            int tries = 0;
            int avail = this.device.available();
            while (avail < len && ++tries < 10) {
                Thread.sleep(100L);
                avail = this.device.available();
            }
            if (avail < len) {
                return response;
            }
            response = this.device.read(len);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading from " + this.deviceName, e);
        }
        return response;
    }

    private static void definePin(Pin pin, String s) {
        PIN_MAP.put(pin, s);
        REVERSE_PIN_MAP.put(s, pin);
    }

    private static Pin createDigitalPin(int address, String name) {
        PinImpl pin = new PinImpl(PROVIDER_NAME, address, name, EnumSet.of(PinMode.DIGITAL_INPUT, PinMode.DIGITAL_OUTPUT), PinPullResistance.all());
        return pin;
    }

    static {
        for (int i = 0; i < 24; ++i) {
            MaestroServoProvider.definePin(MaestroServoProvider.createDigitalPin(i, "" + i), "" + i);
        }
    }

    public static enum InterfaceType {
        USB,
        UART;

    }
}

