/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.piface.impl;

import com.pi4j.component.light.LED;
import com.pi4j.component.light.impl.GpioLEDComponent;
import com.pi4j.component.relay.Relay;
import com.pi4j.component.relay.impl.GpioRelayComponent;
import com.pi4j.component.switches.Switch;
import com.pi4j.component.switches.impl.GpioSwitchComponent;
import com.pi4j.device.DeviceBase;
import com.pi4j.device.piface.PiFace;
import com.pi4j.device.piface.PiFaceLed;
import com.pi4j.device.piface.PiFaceRelay;
import com.pi4j.device.piface.PiFaceSwitch;
import com.pi4j.gpio.extension.piface.PiFaceGpioProvider;
import com.pi4j.gpio.extension.piface.PiFacePin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.spi.SpiChannel;
import java.io.IOException;

public abstract class PiFaceBase
extends DeviceBase
implements PiFace {
    private final GpioController gpio = GpioFactory.getInstance();
    private PiFaceGpioProvider gpioProvider;
    private GpioPinDigitalInput[] inputPins;
    private GpioPinDigitalOutput[] outputPins;
    private Relay[] relays;
    private Switch[] switches;
    private LED[] leds;

    public PiFaceBase(byte spiAddress, int spiChannel) throws IOException {
        this(spiAddress, SpiChannel.getByNumber((int)spiChannel));
    }

    public PiFaceBase(byte spiAddress, SpiChannel spiChannel) throws IOException {
        this.gpioProvider = new PiFaceGpioProvider(spiAddress, spiChannel);
        this.inputPins = new GpioPinDigitalInput[]{this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_00), this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_01), this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_02), this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_03), this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_04), this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_05), this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_06), this.gpio.provisionDigitalInputPin((GpioProvider)this.gpioProvider, PiFacePin.INPUT_07)};
        this.outputPins = new GpioPinDigitalOutput[]{this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_00), this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_01), this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_02), this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_03), this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_04), this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_05), this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_06), this.gpio.provisionDigitalOutputPin((GpioProvider)this.gpioProvider, PiFacePin.OUTPUT_07)};
        this.relays = new Relay[]{new GpioRelayComponent(this.outputPins[0]), new GpioRelayComponent(this.outputPins[1])};
        this.switches = new Switch[]{new GpioSwitchComponent(this.inputPins[0], PinState.HIGH, PinState.LOW), new GpioSwitchComponent(this.inputPins[1], PinState.HIGH, PinState.LOW), new GpioSwitchComponent(this.inputPins[2], PinState.HIGH, PinState.LOW), new GpioSwitchComponent(this.inputPins[3], PinState.HIGH, PinState.LOW)};
        this.leds = new LED[]{new GpioLEDComponent(this.outputPins[0]), new GpioLEDComponent(this.outputPins[1]), new GpioLEDComponent(this.outputPins[2]), new GpioLEDComponent(this.outputPins[3]), new GpioLEDComponent(this.outputPins[4]), new GpioLEDComponent(this.outputPins[5]), new GpioLEDComponent(this.outputPins[6]), new GpioLEDComponent(this.outputPins[7])};
    }

    public GpioController getGpio() {
        return this.gpio;
    }

    public PiFaceGpioProvider getGpioProvider() {
        return this.gpioProvider;
    }

    @Override
    public GpioPinDigitalInput[] getInputPins() {
        return this.inputPins;
    }

    @Override
    public GpioPinDigitalInput getInputPin(int index) {
        return this.inputPins[index];
    }

    @Override
    public GpioPinDigitalOutput[] getOutputPins() {
        return this.outputPins;
    }

    @Override
    public GpioPinDigitalOutput getOutputPin(int index) {
        return this.outputPins[index];
    }

    @Override
    public Relay[] getRelays() {
        return this.relays;
    }

    @Override
    public Relay getRelay(int index) {
        return this.relays[index];
    }

    @Override
    public Relay getRelay(PiFaceRelay relay) {
        return this.relays[relay.getIndex()];
    }

    @Override
    public Switch[] getSwitches() {
        return this.switches;
    }

    @Override
    public Switch getSwitch(int index) {
        return this.switches[index];
    }

    @Override
    public Switch getSwitch(PiFaceSwitch switchValue) {
        return this.switches[switchValue.getIndex()];
    }

    @Override
    public LED[] getLeds() {
        return this.leds;
    }

    @Override
    public LED getLed(int index) {
        return this.leds[index];
    }

    @Override
    public LED getLed(PiFaceLed led) {
        return this.leds[led.getIndex()];
    }
}

