/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.gpiod.internal;

import com.pi4j.library.gpiod.internal.CWrapper;
import com.pi4j.library.gpiod.internal.GpioD;
import com.pi4j.library.gpiod.internal.GpioLineEvent;
import com.pi4j.library.gpiod.internal.LineActiveState;
import com.pi4j.library.gpiod.internal.LineBias;
import com.pi4j.library.gpiod.internal.LineDirection;
import com.pi4j.library.gpiod.internal.LineRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpioLine
extends CWrapper {
    private static final Logger logger = LoggerFactory.getLogger(GpioLine.class);
    private final int offset;

    GpioLine(int offset, long cPointer) {
        super(cPointer);
        this.offset = offset;
    }

    public int getOriginalOffset() {
        return this.offset;
    }

    public int getOffset() {
        return GpioD.lineGetOffset(this.getCPointer());
    }

    public String getName() {
        return GpioD.lineGetName(this.getCPointer());
    }

    public String getConsumer() {
        return GpioD.lineGetConsumer(this.getCPointer());
    }

    public LineDirection getDirection() {
        return GpioD.lineGetDirection(this.getCPointer());
    }

    public LineActiveState getActiveState() {
        return GpioD.lineGetActiveState(this.getCPointer());
    }

    public LineBias getBias() {
        return GpioD.lineGetBias(this.getCPointer());
    }

    public boolean isUsed() {
        return GpioD.lineIsUsed(this.getCPointer());
    }

    public boolean isOpenDrain() {
        return GpioD.lineIsOpenDrain(this.getCPointer());
    }

    public boolean isOpenSource() {
        return GpioD.lineIsOpenSource(this.getCPointer());
    }

    public void update() {
        GpioD.lineUpdate(this.getCPointer());
    }

    public void requestInput(String consumer) {
        GpioD.lineRequestInput(this.getCPointer(), consumer);
    }

    public void requestOutput(String consumer, int defaultVal) {
        GpioD.lineRequestOutput(this.getCPointer(), consumer, defaultVal);
    }

    public void requestRisingEdgeEvents(String consumer) {
        GpioD.lineRequestRisingEdgeEvents(this.getCPointer(), consumer);
    }

    public void requestFallingEdgeEvents(String consumer) {
        GpioD.lineRequestFallingEdgeEvents(this.getCPointer(), consumer);
    }

    public void requestBothEdgeEvents(String consumer) {
        GpioD.lineRequestBothEdgeEvents(this.getCPointer(), consumer);
    }

    public void requestInputFlags(String consumer, int flags) {
        GpioD.lineRequestInputFlags(this.getCPointer(), consumer, flags);
    }

    public void requestOutputFlags(String consumer, int flags, int defaultValue) {
        GpioD.lineRequestOutputFlags(this.getCPointer(), consumer, flags, defaultValue);
    }

    public void requestRisingEdgeEventsFlags(String consumer, int flags) {
        GpioD.lineRequestRisingEdgeEventsFlags(this.getCPointer(), consumer, flags);
    }

    public void requestFallingEdgeEventsFlags(String consumer, int flags) {
        GpioD.lineRequestFallingEdgeEventsFlags(this.getCPointer(), consumer, flags);
    }

    public void requestBothEdgeEventsFlags(String consumer, int flags) {
        GpioD.lineRequestBothEdgeEventsFlags(this.getCPointer(), consumer, flags);
    }

    public boolean isRequested() {
        return GpioD.lineIsRequested(this.getCPointer());
    }

    public boolean isFree() {
        return GpioD.lineIsFree(this.getCPointer());
    }

    public int getValue() {
        return GpioD.lineGetValue(this.getCPointer());
    }

    public void setValue(int value) {
        GpioD.lineSetValue(this.getCPointer(), value);
    }

    public void setConfig(LineRequest direction, int flags, int value) {
        GpioD.lineSetConfig(this.getCPointer(), direction, flags, value);
    }

    public void setFlags(int flags) {
        GpioD.lineSetFlags(this.getCPointer(), flags);
    }

    public void setDirectionInput() {
        GpioD.lineSetDirectionInput(this.getCPointer());
    }

    public void setDirectionOutput(int value) {
        GpioD.lineSetDirectionOutput(this.getCPointer(), value);
    }

    public boolean eventWait(long timeoutNs) {
        return GpioD.lineEventWait(this.getCPointer(), timeoutNs);
    }

    public GpioLineEvent eventRead(GpioLineEvent lineEvent) {
        GpioD.lineEventRead(this.getCPointer(), lineEvent.getCPointer());
        return lineEvent;
    }
}

