/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio;

public enum PiGpioError {
    UNKNOWN(0),
    PI_INIT_FAILED(-1),
    PI_BAD_USER_GPIO(-2),
    PI_BAD_GPIO(-3),
    PI_BAD_MODE(-4),
    PI_BAD_LEVEL(-5),
    PI_BAD_PUD(-6),
    PI_BAD_PULSEWIDTH(-7),
    PI_BAD_DUTYCYCLE(-8),
    PI_BAD_TIMER(-9),
    PI_BAD_MS(-10),
    PI_BAD_TIMETYPE(-11),
    PI_BAD_SECONDS(-12),
    PI_BAD_MICROS(-13),
    PI_TIMER_FAILED(-14),
    PI_BAD_WDOG_TIMEOUT(-15),
    PI_NO_ALERT_FUNC(-16),
    PI_BAD_CLK_PERIPH(-17),
    PI_BAD_CLK_SOURCE(-18),
    PI_BAD_CLK_MICROS(-19),
    PI_BAD_BUF_MILLIS(-20),
    PI_BAD_DUTYRANGE(-21),
    PI_BAD_DUTY_RANGE(-21),
    PI_BAD_SIGNUM(-22),
    PI_BAD_PATHNAME(-23),
    PI_NO_HANDLE(-24),
    PI_BAD_HANDLE(-25),
    PI_BAD_IF_FLAGS(-26),
    PI_BAD_CHANNEL(-27),
    PI_BAD_PRIM_CHANNEL(-27),
    PI_BAD_SOCKET_PORT(-28),
    PI_BAD_FIFO_COMMAND(-29),
    PI_BAD_SECO_CHANNEL(-30),
    PI_NOT_INITIALISED(-31),
    PI_INITIALISED(-32),
    PI_BAD_WAVE_MODE(-33),
    PI_BAD_CFG_INTERNAL(-34),
    PI_BAD_WAVE_BAUD(-35),
    PI_TOO_MANY_PULSES(-36),
    PI_TOO_MANY_CHARS(-37),
    PI_NOT_SERIAL_GPIO(-38),
    PI_BAD_SERIAL_STRUC(-39),
    PI_BAD_SERIAL_BUF(-40),
    PI_NOT_PERMITTED(-41),
    PI_SOME_PERMITTED(-42),
    PI_BAD_WVSC_COMMND(-43),
    PI_BAD_WVSM_COMMND(-44),
    PI_BAD_WVSP_COMMND(-45),
    PI_BAD_PULSELEN(-46),
    PI_BAD_SCRIPT(-47),
    PI_BAD_SCRIPT_ID(-48),
    PI_BAD_SER_OFFSET(-49),
    PI_GPIO_IN_USE(-50),
    PI_BAD_SERIAL_COUNT(-51),
    PI_BAD_PARAM_NUM(-52),
    PI_DUP_TAG(-53),
    PI_TOO_MANY_TAGS(-54),
    PI_BAD_SCRIPT_CMD(-55),
    PI_BAD_VAR_NUM(-56),
    PI_NO_SCRIPT_ROOM(-57),
    PI_NO_MEMORY(-58),
    PI_SOCK_READ_FAILED(-59),
    PI_SOCK_WRIT_FAILED(-60),
    PI_TOO_MANY_PARAM(-61),
    PI_NOT_HALTED(-62),
    PI_SCRIPT_NOT_READY(-62),
    PI_BAD_TAG(-63),
    PI_BAD_MICS_DELAY(-64),
    PI_BAD_MILS_DELAY(-65),
    PI_BAD_WAVE_ID(-66),
    PI_TOO_MANY_CBS(-67),
    PI_TOO_MANY_OOL(-68),
    PI_EMPTY_WAVEFORM(-69),
    PI_NO_WAVEFORM_ID(-70),
    PI_I2C_OPEN_FAILED(-71),
    PI_SER_OPEN_FAILED(-72),
    PI_SPI_OPEN_FAILED(-73),
    PI_BAD_I2C_BUS(-74),
    PI_BAD_I2C_ADDR(-75),
    PI_BAD_SPI_CHANNEL(-76),
    PI_BAD_FLAGS(-77),
    PI_BAD_SPI_SPEED(-78),
    PI_BAD_SER_DEVICE(-79),
    PI_BAD_SER_SPEED(-80),
    PI_BAD_PARAM(-81),
    PI_I2C_WRITE_FAILED(-82),
    PI_I2C_READ_FAILED(-83),
    PI_BAD_SPI_COUNT(-84),
    PI_SER_WRITE_FAILED(-85),
    PI_SER_READ_FAILED(-86),
    PI_SER_READ_NO_DATA(-87),
    PI_UNKNOWN_COMMAND(-88),
    PI_SPI_XFER_FAILED(-89),
    PI_BAD_POINTER(-90),
    PI_NO_AUX_SPI(-91),
    PI_NOT_PWM_GPIO(-92),
    PI_NOT_SERVO_GPIO(-93),
    PI_NOT_HCLK_GPIO(-94),
    PI_NOT_HPWM_GPIO(-95),
    PI_BAD_HPWM_FREQ(-96),
    PI_BAD_HPWM_DUTY(-97),
    PI_BAD_HCLK_FREQ(-98),
    PI_BAD_HCLK_PASS(-99),
    PI_HPWM_ILLEGAL(-100),
    PI_BAD_DATABITS(-101),
    PI_BAD_STOPBITS(-102),
    PI_MSG_TOOBIG(-103),
    PI_BAD_MALLOC_MODE(-104),
    PI_TOO_MANY_SEGS(-105),
    PI_BAD_I2C_SEG(-106),
    PI_BAD_SMBUS_CMD(-107),
    PI_NOT_I2C_GPIO(-108),
    PI_BAD_I2C_WLEN(-109),
    PI_BAD_I2C_RLEN(-110),
    PI_BAD_I2C_CMD(-111),
    PI_BAD_I2C_BAUD(-112),
    PI_CHAIN_LOOP_CNT(-113),
    PI_BAD_CHAIN_LOOP(-114),
    PI_CHAIN_COUNTER(-115),
    PI_BAD_CHAIN_CMD(-116),
    PI_BAD_CHAIN_DELAY(-117),
    PI_CHAIN_NESTING(-118),
    PI_CHAIN_TOO_BIG(-119),
    PI_DEPRECATED(-120),
    PI_BAD_SER_INVERT(-121),
    PI_BAD_EDGE(-122),
    PI_BAD_ISR_INIT(-123),
    PI_BAD_FOREVER(-124),
    PI_BAD_FILTER(-125),
    PI_BAD_PAD(-126),
    PI_BAD_STRENGTH(-127),
    PI_FIL_OPEN_FAILED(-128),
    PI_BAD_FILE_MODE(-129),
    PI_BAD_FILE_FLAG(-130),
    PI_BAD_FILE_READ(-131),
    PI_BAD_FILE_WRITE(-132),
    PI_FILE_NOT_ROPEN(-133),
    PI_FILE_NOT_WOPEN(-134),
    PI_BAD_FILE_SEEK(-135),
    PI_NO_FILE_MATCH(-136),
    PI_NO_FILE_ACCESS(-137),
    PI_FILE_IS_A_DIR(-138),
    PI_BAD_SHELL_STATUS(-139),
    PI_BAD_SCRIPT_NAME(-140),
    PI_BAD_SPI_BAUD(-141),
    PI_NOT_SPI_GPIO(-142),
    PI_BAD_EVENT_ID(-143),
    PI_CMD_INTERRUPTED(-144),
    PI_NOT_ON_BCM2711(-145),
    PI_ONLY_ON_BCM2711(-146),
    PI_PIGIF_ERR_0(-2000),
    PI_PIGIF_ERR_99(-2099),
    PI_CUSTOM_ERR_0(-3000),
    PI_CUSTOM_ERR_999(-3999);

    private int value;

    private PiGpioError(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public String message() {
        switch (this) {
            case UNKNOWN: {
                return "Unknown";
            }
            case PI_INIT_FAILED: {
                return "pigpio initialisation failed";
            }
            case PI_BAD_USER_GPIO: {
                return "GPIO not 0-31";
            }
            case PI_BAD_GPIO: {
                return "GPIO not 0-53";
            }
            case PI_BAD_MODE: {
                return "mode not 0-7";
            }
            case PI_BAD_LEVEL: {
                return "level not 0-1";
            }
            case PI_BAD_PUD: {
                return "pud not 0-2";
            }
            case PI_BAD_PULSEWIDTH: {
                return "pulsewidth not 0 or 500-2500";
            }
            case PI_BAD_DUTYCYCLE: {
                return "dutycycle not 0-range (default 255)";
            }
            case PI_BAD_TIMER: {
                return "timer not 0-9";
            }
            case PI_BAD_MS: {
                return "ms not 10-60000";
            }
            case PI_BAD_TIMETYPE: {
                return "timetype not 0-1";
            }
            case PI_BAD_SECONDS: {
                return "seconds < 0";
            }
            case PI_BAD_MICROS: {
                return "micros not 0-999999";
            }
            case PI_TIMER_FAILED: {
                return "gpioSetTimerFunc failed";
            }
            case PI_BAD_WDOG_TIMEOUT: {
                return "timeout not 0-60000";
            }
            case PI_NO_ALERT_FUNC: {
                return "DEPRECATED";
            }
            case PI_BAD_CLK_PERIPH: {
                return "clock peripheral not 0-1";
            }
            case PI_BAD_CLK_SOURCE: {
                return "DEPRECATED";
            }
            case PI_BAD_CLK_MICROS: {
                return "clock micros not 1: return 2: return 4: return 5: return 8: return or 10";
            }
            case PI_BAD_BUF_MILLIS: {
                return "buf millis not 100-10000";
            }
            case PI_BAD_DUTYRANGE: {
                return "dutycycle range not 25-40000";
            }
            case PI_BAD_SIGNUM: {
                return "signum not 0-63";
            }
            case PI_BAD_PATHNAME: {
                return "can't open pathname";
            }
            case PI_NO_HANDLE: {
                return "no handle available";
            }
            case PI_BAD_HANDLE: {
                return "unknown handle";
            }
            case PI_BAD_IF_FLAGS: {
                return "ifFlags > 4";
            }
            case PI_BAD_CHANNEL: {
                return "DMA channel not 0-14";
            }
            case PI_BAD_SOCKET_PORT: {
                return "socket port not 1024-30000";
            }
            case PI_BAD_FIFO_COMMAND: {
                return "unknown fifo command";
            }
            case PI_BAD_SECO_CHANNEL: {
                return "DMA secondary channel not 0-14";
            }
            case PI_NOT_INITIALISED: {
                return "function called before gpioInitialise";
            }
            case PI_INITIALISED: {
                return "function called after gpioInitialise";
            }
            case PI_BAD_WAVE_MODE: {
                return "waveform mode not 0-1";
            }
            case PI_BAD_CFG_INTERNAL: {
                return "bad parameter in gpioCfgInternals call";
            }
            case PI_BAD_WAVE_BAUD: {
                return "baud rate not 50-250K(RX)/50-1M(TX)";
            }
            case PI_TOO_MANY_PULSES: {
                return "waveform has too many pulses";
            }
            case PI_TOO_MANY_CHARS: {
                return "waveform has too many chars";
            }
            case PI_NOT_SERIAL_GPIO: {
                return "no bit bang serial read in progress on GPIO";
            }
            case PI_BAD_SERIAL_STRUC: {
                return "bad (null) serial structure parameter";
            }
            case PI_BAD_SERIAL_BUF: {
                return "bad (null) serial buf parameter";
            }
            case PI_NOT_PERMITTED: {
                return "no permission to update GPIO";
            }
            case PI_SOME_PERMITTED: {
                return "no permission to update one or more GPIO";
            }
            case PI_BAD_WVSC_COMMND: {
                return "bad WVSC subcommand";
            }
            case PI_BAD_WVSM_COMMND: {
                return "bad WVSM subcommand";
            }
            case PI_BAD_WVSP_COMMND: {
                return "bad WVSP subcommand";
            }
            case PI_BAD_PULSELEN: {
                return "trigger pulse length not 1-100";
            }
            case PI_BAD_SCRIPT: {
                return "invalid script";
            }
            case PI_BAD_SCRIPT_ID: {
                return "unknown script id";
            }
            case PI_BAD_SER_OFFSET: {
                return "add serial data offset > 30 minute";
            }
            case PI_GPIO_IN_USE: {
                return "GPIO already in use";
            }
            case PI_BAD_SERIAL_COUNT: {
                return "must read at least a byte at a time";
            }
            case PI_BAD_PARAM_NUM: {
                return "script parameter id not 0-9";
            }
            case PI_DUP_TAG: {
                return "script has duplicate tag";
            }
            case PI_TOO_MANY_TAGS: {
                return "script has too many tags";
            }
            case PI_BAD_SCRIPT_CMD: {
                return "illegal script command";
            }
            case PI_BAD_VAR_NUM: {
                return "script variable id not 0-149";
            }
            case PI_NO_SCRIPT_ROOM: {
                return "no more room for scripts";
            }
            case PI_NO_MEMORY: {
                return "can't allocate temporary memory";
            }
            case PI_SOCK_READ_FAILED: {
                return "socket read failed";
            }
            case PI_SOCK_WRIT_FAILED: {
                return "socket write failed";
            }
            case PI_TOO_MANY_PARAM: {
                return "too many script parameters (> 10)";
            }
            case PI_SCRIPT_NOT_READY: {
                return "script initialising";
            }
            case PI_BAD_TAG: {
                return "script has unresolved tag";
            }
            case PI_BAD_MICS_DELAY: {
                return "bad MICS delay (too large)";
            }
            case PI_BAD_MILS_DELAY: {
                return "bad MILS delay (too large)";
            }
            case PI_BAD_WAVE_ID: {
                return "non existent wave id";
            }
            case PI_TOO_MANY_CBS: {
                return "No more CBs for waveform";
            }
            case PI_TOO_MANY_OOL: {
                return "No more OOL for waveform";
            }
            case PI_EMPTY_WAVEFORM: {
                return "attempt to create an empty waveform";
            }
            case PI_NO_WAVEFORM_ID: {
                return "no more waveform ids";
            }
            case PI_I2C_OPEN_FAILED: {
                return "can't open I2C device";
            }
            case PI_SER_OPEN_FAILED: {
                return "can't open serial device";
            }
            case PI_SPI_OPEN_FAILED: {
                return "can't open SPI device";
            }
            case PI_BAD_I2C_BUS: {
                return "bad I2C bus";
            }
            case PI_BAD_I2C_ADDR: {
                return "bad I2C address";
            }
            case PI_BAD_SPI_CHANNEL: {
                return "bad SPI channel";
            }
            case PI_BAD_FLAGS: {
                return "bad i2c/spi/ser open flags";
            }
            case PI_BAD_SPI_SPEED: {
                return "bad SPI speed";
            }
            case PI_BAD_SER_DEVICE: {
                return "bad serial device name";
            }
            case PI_BAD_SER_SPEED: {
                return "bad serial baud rate";
            }
            case PI_BAD_PARAM: {
                return "bad i2c/spi/ser parameter";
            }
            case PI_I2C_WRITE_FAILED: {
                return "I2C write failed";
            }
            case PI_I2C_READ_FAILED: {
                return "I2C read failed";
            }
            case PI_BAD_SPI_COUNT: {
                return "bad SPI count";
            }
            case PI_SER_WRITE_FAILED: {
                return "ser write failed";
            }
            case PI_SER_READ_FAILED: {
                return "ser read failed";
            }
            case PI_SER_READ_NO_DATA: {
                return "ser read no data available";
            }
            case PI_UNKNOWN_COMMAND: {
                return "unknown command";
            }
            case PI_SPI_XFER_FAILED: {
                return "spi xfer/read/write failed";
            }
            case PI_BAD_POINTER: {
                return "bad (NULL) pointer";
            }
            case PI_NO_AUX_SPI: {
                return "no auxiliary SPI on Pi A or B";
            }
            case PI_NOT_PWM_GPIO: {
                return "GPIO is not in use for PWM";
            }
            case PI_NOT_SERVO_GPIO: {
                return "GPIO is not in use for servo pulses";
            }
            case PI_NOT_HCLK_GPIO: {
                return "GPIO has no hardware clock";
            }
            case PI_NOT_HPWM_GPIO: {
                return "GPIO has no hardware PWM";
            }
            case PI_BAD_HPWM_FREQ: {
                return "invalid hardware PWM frequency";
            }
            case PI_BAD_HPWM_DUTY: {
                return "hardware PWM dutycycle not 0-1M";
            }
            case PI_BAD_HCLK_FREQ: {
                return "invalid hardware clock frequency";
            }
            case PI_BAD_HCLK_PASS: {
                return "need password to use hardware clock 1";
            }
            case PI_HPWM_ILLEGAL: {
                return "illegal: return PWM in use for main clock";
            }
            case PI_BAD_DATABITS: {
                return "serial data bits not 1-32";
            }
            case PI_BAD_STOPBITS: {
                return "serial (half) stop bits not 2-8";
            }
            case PI_MSG_TOOBIG: {
                return "socket/pipe message too big";
            }
            case PI_BAD_MALLOC_MODE: {
                return "bad memory allocation mode";
            }
            case PI_TOO_MANY_SEGS: {
                return "too many I2C transaction segments";
            }
            case PI_BAD_I2C_SEG: {
                return "an I2C transaction segment failed";
            }
            case PI_BAD_SMBUS_CMD: {
                return "SMBus command not supported by driver";
            }
            case PI_NOT_I2C_GPIO: {
                return "no bit bang I2C in progress on GPIO";
            }
            case PI_BAD_I2C_WLEN: {
                return "bad I2C write length";
            }
            case PI_BAD_I2C_RLEN: {
                return "bad I2C read length";
            }
            case PI_BAD_I2C_CMD: {
                return "bad I2C command";
            }
            case PI_BAD_I2C_BAUD: {
                return "bad I2C baud rate: return not 50-500k";
            }
            case PI_CHAIN_LOOP_CNT: {
                return "bad chain loop count";
            }
            case PI_BAD_CHAIN_LOOP: {
                return "empty chain loop";
            }
            case PI_CHAIN_COUNTER: {
                return "too many chain counters";
            }
            case PI_BAD_CHAIN_CMD: {
                return "bad chain command";
            }
            case PI_BAD_CHAIN_DELAY: {
                return "bad chain delay micros";
            }
            case PI_CHAIN_NESTING: {
                return "chain counters nested too deeply";
            }
            case PI_CHAIN_TOO_BIG: {
                return "chain is too long";
            }
            case PI_DEPRECATED: {
                return "deprecated function removed";
            }
            case PI_BAD_SER_INVERT: {
                return "bit bang serial invert not 0 or 1";
            }
            case PI_BAD_EDGE: {
                return "bad ISR edge: return not 1: return 1: return or 2";
            }
            case PI_BAD_ISR_INIT: {
                return "bad ISR initialisation";
            }
            case PI_BAD_FOREVER: {
                return "loop forever must be last chain command";
            }
            case PI_BAD_FILTER: {
                return "bad filter parameter";
            }
            case PI_BAD_PAD: {
                return "bad pad number";
            }
            case PI_BAD_STRENGTH: {
                return "bad pad drive strength";
            }
            case PI_FIL_OPEN_FAILED: {
                return "file open failed";
            }
            case PI_BAD_FILE_MODE: {
                return "bad file mode";
            }
            case PI_BAD_FILE_FLAG: {
                return "bad file flag";
            }
            case PI_BAD_FILE_READ: {
                return "bad file read";
            }
            case PI_BAD_FILE_WRITE: {
                return "bad file write";
            }
            case PI_FILE_NOT_ROPEN: {
                return "file not open for read";
            }
            case PI_FILE_NOT_WOPEN: {
                return "file not open for write";
            }
            case PI_BAD_FILE_SEEK: {
                return "bad file seek";
            }
            case PI_NO_FILE_MATCH: {
                return "no files match pattern";
            }
            case PI_NO_FILE_ACCESS: {
                return "no permission to access file";
            }
            case PI_FILE_IS_A_DIR: {
                return "file is a directory";
            }
            case PI_BAD_SHELL_STATUS: {
                return "bad shell return status";
            }
            case PI_BAD_SCRIPT_NAME: {
                return "bad script name";
            }
            case PI_BAD_SPI_BAUD: {
                return "bad SPI baud rate: return not 50-500k";
            }
            case PI_NOT_SPI_GPIO: {
                return "no bit bang SPI in progress on GPIO";
            }
            case PI_BAD_EVENT_ID: {
                return "bad event id";
            }
            case PI_CMD_INTERRUPTED: {
                return "command interrupted: return Python";
            }
            case PI_NOT_ON_BCM2711: {
                return "not available on BCM2711";
            }
            case PI_ONLY_ON_BCM2711: {
                return "only available on BCM2711";
            }
        }
        return "Not listed";
    }

    public static PiGpioError from(Number value) {
        for (PiGpioError c : PiGpioError.values()) {
            if (c.value() != value.intValue()) continue;
            return c;
        }
        return UNKNOWN;
    }
}

