/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.impl;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioException;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.library.pigpio.PiGpioPud;
import com.pi4j.library.pigpio.PiGpioState;
import com.pi4j.library.pigpio.PiGpioStateChangeEvent;
import com.pi4j.library.pigpio.impl.PiGpioBase;
import com.pi4j.library.pigpio.internal.PIGPIO;
import com.pi4j.library.pigpio.internal.PiGpioAlertCallback;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioNativeImpl
extends PiGpioBase
implements PiGpio {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private PiGpioAlertCallback gpioAlertCallbackHandler = new PiGpioAlertCallback(){

        @Override
        public void call(int pin, int state, long tick) {
            try {
                PiGpioNativeImpl.this.dispatchEvent(new PiGpioStateChangeEvent(pin, PiGpioState.from(state), tick));
            }
            catch (Exception e) {
                PiGpioNativeImpl.this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    };

    public static PiGpio newInstance() {
        return new PiGpioNativeImpl();
    }

    private PiGpioNativeImpl() {
        this.initialized = false;
    }

    @Override
    public int gpioInitialise() {
        int result = 0;
        this.logger.trace("[INITIALIZE] -> STARTED");
        if (!this.initialized) {
            int rslt = PIGPIO.gpioCfgInterfaces(3);
            this.validateResult(rslt);
            result = PIGPIO.gpioInitialise();
            this.validateResult(result);
            this.initialized = true;
            this.logger.debug("[INITIALIZE] -- INITIALIZED SUCCESSFULLY");
        } else {
            this.logger.warn("[INITIALIZE] -- ALREADY INITIALIZED");
        }
        this.logger.trace("[INITIALIZE] <- FINISHED");
        return result;
    }

    @Override
    public void gpioTerminate() {
        this.logger.trace("[SHUTDOWN] -> STARTED");
        if (this.initialized) {
            this.closeAllOpenHandles();
        }
        PIGPIO.gpioTerminate();
        this.initialized = false;
        this.logger.trace("[SHUTDOWN] <- FINISHED");
    }

    @Override
    public int gpioVersion() {
        this.logger.trace("[VERSION] -> GET VERSION");
        this.validateReady();
        int version = PIGPIO.gpioVersion();
        this.logger.trace("[VERSION] <- RESULT={}", (Object)version);
        return version;
    }

    @Override
    public long gpioHardwareRevision() {
        this.logger.trace("[HARDWARE] -> GET REVISION");
        this.validateReady();
        int revision = PIGPIO.gpioHardwareRevision();
        this.logger.trace("[HARDWARE] <- REVISION: {}", (Object)revision);
        if (revision <= 0) {
            throw new PiGpioException("Hardware revision could not be determined.");
        }
        return revision;
    }

    @Override
    public void gpioSetPullUpDown(int pin, PiGpioPud pud) {
        this.logger.trace("[GPIO::PUD-SET] -> PIN: {}; PUD={}({});", new Object[]{pin, pud.name(), pud.value()});
        this.validateReady();
        this.validatePin(pin);
        int result = PIGPIO.gpioSetPullUpDown(pin, pud.value());
        this.logger.trace("[GPIO::PUD-SET] <- PIN: {}; PUD={}({}); SUCCESS={}", new Object[]{pud.name(), pud.value(), result >= 0});
        this.validateResult(result);
    }

    @Override
    public PiGpioMode gpioGetMode(int pin) {
        this.logger.trace("[GPIO::MODE-GET] -> PIN: {};", (Object)pin);
        this.validateReady();
        this.validatePin(pin);
        int result = PIGPIO.gpioGetMode(pin);
        this.validateResult(result);
        PiGpioMode mode = PiGpioMode.from(result);
        this.logger.trace("[GPIO::MODE-GET] <- PIN: {}; MODE={}({})", new Object[]{pin, mode.name(), mode.value()});
        return mode;
    }

    @Override
    public void gpioSetMode(int pin, PiGpioMode mode) {
        this.logger.trace("[GPIO::MODE-SET] -> PIN: {}; MODE={}({});", new Object[]{pin, mode.name(), mode.value()});
        this.validateReady();
        this.validatePin(pin);
        int result = PIGPIO.gpioSetMode(pin, mode.value());
        this.logger.trace("[GPIO::MODE-SET] <- PIN: {}; MODE={}({}); SUCCESS={}", new Object[]{mode.name(), mode.value(), result >= 0});
        this.validateResult(result);
    }

    @Override
    public PiGpioState gpioRead(int pin) {
        this.logger.trace("[GPIO::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validatePin(pin);
        int result = PIGPIO.gpioRead(pin);
        this.validateResult(result);
        PiGpioState state = PiGpioState.from(result);
        this.logger.trace("[GPIO::GET] <- PIN: {} is {}({})", new Object[]{pin, state.name(), state.value()});
        return state;
    }

    @Override
    public void gpioWrite(int pin, PiGpioState state) {
        this.logger.trace("[GPIO::SET] -> PIN: {}; {}({});", new Object[]{pin, state.name(), state.value()});
        this.validateReady();
        this.validatePin(pin);
        int result = PIGPIO.gpioWrite(pin, state.value());
        this.logger.trace("[GPIO::SET] <- PIN: {}; {}({}); SUCCESS={}", new Object[]{pin, state.name(), state.value(), result >= 0});
        this.validateResult(result);
    }

    @Override
    public void gpioGlitchFilter(int pin, int steady) {
        this.logger.trace("[GPIO::GLITCH] -> PIN: {}; INTERVAL: {};", (Object)pin, (Object)steady);
        this.validateReady();
        this.validatePin(pin);
        this.validateGpioGlitchFilter(steady);
        int result = PIGPIO.gpioGlitchFilter(pin, steady);
        this.logger.trace("[GPIO::GLITCH] <- PIN: {}; SUCCESS={}", (Object)pin, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result);
    }

    @Override
    public void gpioNoiseFilter(int pin, int steady, int active) {
        this.logger.trace("[GPIO::NOISE] -> PIN: {}; INTERVAL: {};", (Object)pin, (Object)steady);
        this.validateReady();
        this.validatePin(pin);
        this.validateGpioNoiseFilter(steady, active);
        int result = PIGPIO.gpioNoiseFilter(pin, steady, active);
        this.logger.trace("[GPIO::NOISE] <- PIN: {}; SUCCESS={}", (Object)pin, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result);
    }

    @Override
    public void gpioPWM(int pin, int dutyCycle) {
        this.logger.trace("[PWM::SET] -> PIN: {}; DUTY-CYCLE={};", (Object)pin, (Object)dutyCycle);
        this.validateReady();
        this.validateUserPin(pin);
        this.validateDutyCycle(dutyCycle);
        int result = PIGPIO.gpioPWM(pin, dutyCycle);
        this.logger.trace("[PWM::SET] <- PIN: {}; DUTY-CYCLE={}; SUCCESS={}", new Object[]{pin, dutyCycle, result >= 0});
        this.validateResult(result);
    }

    @Override
    public int gpioGetPWMdutycycle(int pin) {
        this.logger.trace("[PWM::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioGetPWMdutycycle(pin);
        this.logger.trace("[PWM::GET] <- PIN: {}; DUTY-CYCLE={}; SUCCESS={}", new Object[]{pin, result, result >= 0});
        this.validateResult(result);
        return result;
    }

    @Override
    public int gpioSetPWMrange(int pin, int range) {
        this.logger.trace("[PWM-RANGE::SET] -> PIN: {}; RANGE={}", (Object)pin, (Object)range);
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioSetPWMrange(pin, range);
        this.logger.trace("[PWM-RANGE::SET] <- PIN: {}; REAL-RANGE={}; SUCCESS={}", new Object[]{pin, result, result >= 0});
        this.validateResult(result);
        return result;
    }

    @Override
    public int gpioGetPWMrange(int pin) {
        this.logger.trace("[PWM-RANGE::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioGetPWMrange(pin);
        this.logger.trace("[PWM-RANGE::GET] <- PIN: {}; RANGE={}; SUCCESS={}", new Object[]{pin, result, result >= 0});
        this.validateResult(result);
        return result;
    }

    @Override
    public int gpioGetPWMrealRange(int pin) {
        this.logger.trace("[PWM-REAL-RANGE::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioGetPWMrealRange(pin);
        this.logger.trace("[PWM-REAL-RANGE::GET] <- PIN: {}; RANGE={}; SUCCESS={}", new Object[]{pin, result, result >= 0});
        this.validateResult(result);
        return result;
    }

    @Override
    public int gpioSetPWMfrequency(int pin, int frequency) {
        this.logger.trace("[PWM-FREQ::SET] -> PIN: {}; FREQUENCY={}", (Object)pin, (Object)frequency);
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioSetPWMfrequency(pin, frequency);
        this.logger.trace("[PWM-FREQ::SET] <- PIN: {}; FREQUENCY={}; SUCCESS={}", new Object[]{pin, result, result >= 0});
        this.validateResult(result);
        return result;
    }

    @Override
    public int gpioGetPWMfrequency(int pin) {
        this.logger.trace("[PWM-FREQ::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioGetPWMfrequency(pin);
        this.logger.trace("[PWM-FREQ::GET] <- PIN: {}; FREQUENCY={}; SUCCESS={}", new Object[]{pin, result, result >= 0});
        this.validateResult(result);
        return result;
    }

    @Override
    public void gpioHardwarePWM(int pin, int frequency, int dutyCycle) {
        this.logger.trace("[HW-PWM::SET] -> PIN: {}; FREQUENCY={}; DUTY-CYCLE={}", new Object[]{pin, frequency, dutyCycle});
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioHardwarePWM(pin, frequency, dutyCycle);
        this.logger.trace("[HW-PWM::SET] <- PIN: {}; SUCCESS={}", (Object)pin, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result);
    }

    @Override
    public void gpioNotifications(int pin, boolean enabled) {
        if (enabled) {
            PIGPIO.gpioSetAlertFunc(pin, this.gpioAlertCallbackHandler);
        } else {
            PIGPIO.gpioDisableAlertFunc(pin);
        }
    }

    @Override
    public void gpioServo(int pin, int pulseWidth) {
        this.logger.trace("[SERVO::SET] -> PIN: {}; PULSE-WIDTH={};", (Object)pin, (Object)pulseWidth);
        this.validateReady();
        this.validateUserPin(pin);
        this.validatePulseWidth(pulseWidth);
        int result = PIGPIO.gpioServo(pin, pulseWidth);
        this.logger.trace("[SERVO::SET] <- PIN: {}; PULSE-WIDTH={}; SUCCESS={}", new Object[]{pin, pulseWidth, result >= 0});
        this.validateResult(result);
    }

    @Override
    public int gpioGetServoPulsewidth(int pin) {
        this.logger.trace("[SERVO::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        int result = PIGPIO.gpioGetServoPulsewidth(pin);
        this.logger.trace("[SERVO::GET] <- PIN: {}; PULSE-WIDTH={}; SUCCESS={}", new Object[]{pin, result, result >= 0});
        this.validateResult(result);
        return result;
    }

    @Override
    public long gpioDelay(long micros) {
        this.logger.trace("[DELAY] -> MICROS: {}", (Object)micros);
        this.validateReady();
        this.validateDelayMicroseconds(micros);
        long result = PIGPIO.gpioDelay(micros);
        this.logger.trace("[DELAY] <- MICROS: {}; SUCCESS={}", (Object)micros, (Object)(result >= 0L ? 1 : 0));
        this.validateResult(result);
        return result;
    }

    @Override
    public int gpioDelayMilliseconds(int millis) {
        this.logger.trace("[DELAY] -> MILLIS: {}", (Object)millis);
        this.validateReady();
        this.validateDelayMilliseconds(millis);
        long total_micros = millis * 1000;
        int seconds = (int)(total_micros / 1000000L);
        int micros = (int)(total_micros % 1000000L);
        int result = PIGPIO.gpioSleep(0, seconds, micros);
        this.logger.trace("[DELAY] <- MILLIS: {}; SUCCESS={}", (Object)millis, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result);
        return millis;
    }

    @Override
    public long gpioTick() {
        this.logger.trace("[TICK::GET] -> Get current tick");
        this.validateReady();
        long result = PIGPIO.gpioTick();
        this.logger.trace("[TICK::GET] <- TICK: {}; SUCCESS={}", (Object)result, (Object)(result >= 0L ? 1 : 0));
        return result;
    }

    @Override
    public int i2cOpen(int bus, int device, int flags) {
        this.logger.trace("[I2C::OPEN] -> Open I2C Bus [{}] and Device [{}]; FLAGS=[{}]", new Object[]{bus, device, flags});
        this.validateReady();
        this.validateI2cBus(bus);
        this.validateI2cDeviceAddress(device);
        int handle = PIGPIO.i2cOpen(bus, device, flags);
        boolean success = handle >= 0;
        this.logger.trace("[I2C::OPEN] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)success);
        this.validateResult(handle, false);
        if (success) {
            this.i2cHandles.add(handle);
        }
        return handle;
    }

    @Override
    public int i2cClose(int handle) {
        this.logger.trace("[I2C::CLOSE] -> HANDLE={}, Close I2C Bus", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.i2cClose(handle);
        boolean success = result >= 0;
        this.logger.trace("[I2C::CLOSE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        if (success) {
            this.i2cHandles.remove(handle);
        }
        return result;
    }

    @Override
    public int i2cWriteQuick(int handle, boolean bit) {
        this.logger.trace("[I2C::WRITE] -> HANDLE={}; R/W Bit [{}]", (Object)handle, (Object)(bit ? 1 : 0));
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.i2cWriteQuick(handle, bit);
        boolean success = result >= 0;
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cWriteByte(int handle, byte value) {
        this.logger.trace("[I2C::WRITE] -> HANDLE={}; Byte [{}]", (Object)handle, (Object)Byte.toUnsignedInt(value));
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.i2cWriteByte(handle, value);
        boolean success = result >= 0;
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cReadByte(int handle) {
        this.logger.trace("[I2C::READ] -> [{}]; Byte", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.i2cReadByte(handle);
        boolean success = result >= 0;
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cWriteByteData(int handle, int register, byte value) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; Byte [{}]", new Object[]{handle, register, Byte.toUnsignedInt(value)});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        int result = PIGPIO.i2cWriteByteData(handle, register, value);
        boolean success = result >= 0;
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cWriteWordData(int handle, int register, int value) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; Word [{}]", new Object[]{handle, register, value});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        int result = PIGPIO.i2cWriteWordData(handle, register, value);
        boolean success = result >= 0;
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cReadByteData(int handle, int register) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; Byte", (Object)handle, (Object)register);
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        int result = PIGPIO.i2cReadByteData(handle, register);
        boolean success = result >= 0;
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cReadWordData(int handle, int register) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; Word", (Object)handle, (Object)register);
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        int result = PIGPIO.i2cReadWordData(handle, register);
        boolean success = result >= 0;
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cProcessCall(int handle, int register, int value) {
        this.logger.trace("[I2C::W/R] -> [{}]; Register [{}]; Word [{}]", new Object[]{handle, register, value});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        int result = PIGPIO.i2cProcessCall(handle, register, value);
        boolean success = result >= 0;
        this.logger.trace("[I2C::W/R] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cWriteBlockData(int handle, int register, byte[] data, int offset, int length) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        this.validateI2cBlockLength(length);
        Objects.checkFromIndexSize(offset, length, data.length);
        int result = PIGPIO.i2cWriteBlockData(handle, register, data, offset, length);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, result >= 0, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cReadBlockData(int handle, int register, byte[] buffer, int offset, int length) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; Block [{} bytes]; offset={}", new Object[]{handle, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        Objects.checkFromIndexSize(offset, length, buffer.length);
        int result = PIGPIO.i2cReadBlockData(handle, register, buffer, offset);
        boolean success = result >= 0;
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cBlockProcessCall(int handle, int register, byte[] data, int offset, int length) {
        this.logger.trace("[I2C::W/R] -> [{}]; Register [{}]; Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        Objects.checkFromIndexSize(offset, length, data.length);
        int result = PIGPIO.i2cBlockProcessCall(handle, register, data, offset, length);
        boolean success = result >= 0;
        this.logger.trace("[I2C::W/R] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cBlockProcessCall(int handle, int register, byte[] write, int writeOffset, int writeLength, byte[] read, int readOffset) {
        this.logger.trace("[I2C::W/R] -> [{}]; Register [{}]; Block [{} bytes]; woff={}, roff={}", new Object[]{handle, register, writeLength, writeOffset, readOffset});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        this.validateI2cBlockLength(writeLength);
        Objects.checkFromIndexSize(writeOffset, writeLength, write.length);
        Objects.checkFromIndexSize(readOffset, writeLength, read.length);
        byte[] buffer = Arrays.copyOfRange(write, writeOffset, writeOffset + writeLength);
        int result = PIGPIO.i2cBlockProcessCall(handle, register, buffer, 0, writeLength);
        boolean success = result >= 0;
        this.logger.trace("[I2C::W/R] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        if (success) {
            int readLength = result;
            if (buffer.length < readLength) {
                readLength = buffer.length;
            }
            Objects.checkFromIndexSize(readOffset, readLength, read.length);
            System.arraycopy(buffer, 0, read, readOffset, readLength);
        }
        return result;
    }

    @Override
    public int i2cReadI2CBlockData(int handle, int register, byte[] buffer, int offset, int length) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; I2C Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        Objects.checkFromIndexSize(offset, length, buffer.length);
        int result = PIGPIO.i2cReadI2CBlockData(handle, register, buffer, offset, length);
        boolean success = result >= 0;
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cWriteI2CBlockData(int handle, int register, byte[] data, int offset, int length) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; I2C Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        this.validateI2cBlockLength(length);
        Objects.checkFromIndexSize(offset, length, data.length);
        int result = PIGPIO.i2cWriteI2CBlockData(handle, register, data, offset, length);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, result >= 0, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cReadDevice(int handle, byte[] buffer, int offset, int length) {
        this.logger.trace("[I2C::READ] -> [{}]; I2C Raw Read [{} bytes]; offset={}", new Object[]{handle, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        Objects.checkFromIndexSize(offset, length, buffer.length);
        int result = PIGPIO.i2cReadDevice(handle, buffer, offset, length);
        boolean success = result >= 0;
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int i2cWriteDevice(int handle, byte[] data, int offset, int length) {
        this.logger.trace("[I2C::WRITE] -> [{}]; I2C Raw Write [{} bytes]; offset={}", new Object[]{handle, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        Objects.checkFromIndexSize(offset, length, data.length);
        int result = PIGPIO.i2cWriteDevice(handle, data, offset, length);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, result >= 0, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int serOpen(CharSequence device, int baud, int flags) {
        int result;
        this.logger.trace("[SERIAL::OPEN] -> Open Serial Port [{}] at Baud Rate [{}]", (Object)device, (Object)baud);
        this.validateReady();
        int handle = result = PIGPIO.serOpen(device.toString(), baud, flags);
        boolean success = result >= 0;
        this.logger.trace("[SERIAL::OPEN] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)success);
        this.validateResult(result, false);
        if (success) {
            this.serialHandles.add(handle);
        }
        return handle;
    }

    @Override
    public int serClose(int handle) {
        this.logger.trace("[SERIAL::CLOSE] -> HANDLE={}, Close Serial Port", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.serClose(handle);
        boolean success = result >= 0;
        this.logger.trace("[SERIAL::CLOSE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)success);
        this.validateResult(result, false);
        if (success) {
            this.serialHandles.remove(handle);
        }
        return result;
    }

    @Override
    public int serWriteByte(int handle, byte value) {
        this.logger.trace("[SERIAL::WRITE] -> HANDLE={}; Byte [{}]", (Object)handle, (Object)Byte.toUnsignedInt(value));
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.serWriteByte(handle, value);
        this.logger.trace("[SERIAL::WRITE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result, false);
        return 0;
    }

    @Override
    public int serReadByte(int handle) {
        this.logger.trace("[SERIAL::READ] -> [{}]; Byte", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.serReadByte(handle);
        this.logger.trace("[SERIAL::READ] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int serWrite(int handle, byte[] data, int offset, int length) {
        this.logger.trace("[SERIAL::WRITE] -> [{}]; Serial Write [{} bytes]", (Object)handle, (Object)data.length);
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, data.length);
        this.validateHandle(handle);
        int result = PIGPIO.serWrite(handle, data, offset, length);
        this.logger.trace("[SERIAL::WRITE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int serRead(int handle, byte[] buffer, int offset, int length) {
        this.logger.trace("[SERIAL::READ] -> [{}]; Serial Read [{} bytes]", (Object)handle, (Object)length);
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.validateHandle(handle);
        int result = PIGPIO.serRead(handle, buffer, offset, length);
        boolean success = result >= 0;
        this.logger.trace("[SERIAL::READ] <- HANDLE={}; SUCCESS={}; BYTES-READ={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int serDataAvailable(int handle) {
        this.logger.trace("[SERIAL::AVAIL] -> Get number of bytes available to read");
        this.validateReady();
        int result = PIGPIO.serDataAvailable(handle);
        this.logger.trace("[SERIAL::AVAIL] <- HANDLE={}; SUCCESS={}; AVAILABLE={}", new Object[]{handle, result >= 0, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int serDrain(int handle) {
        this.logger.trace("[SERIAL::DRAIN] -> Drain any remaining bytes in serial RX buffer");
        this.validateReady();
        int result = PIGPIO.serDrain(handle);
        this.validateResult(result, false);
        this.logger.trace("[SERIAL::DRAIN] <- HANDLE={}; SUCCESS={}; DRAINED={}", new Object[]{handle, result >= 0, result});
        return result;
    }

    @Override
    public int spiOpen(int channel, int baud, int flags) {
        this.logger.trace("[SPI::OPEN] -> Open SPI Channel [{}] at Baud Rate [{}]; Flags=[{}]", new Object[]{channel, baud, flags});
        this.validateReady();
        int handle = PIGPIO.spiOpen(channel, baud, flags);
        boolean success = handle >= 0;
        this.logger.trace("[SPI::OPEN] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)success);
        this.validateResult(handle, false);
        if (success) {
            this.spiHandles.add(handle);
        }
        return handle;
    }

    @Override
    public int spiClose(int handle) {
        this.logger.trace("[SPI::CLOSE] -> HANDLE={}, Close Serial Port", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        int result = PIGPIO.spiClose(handle);
        boolean success = result >= 0;
        this.logger.trace("[SPI::CLOSE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)success);
        this.validateResult(result, false);
        if (success) {
            this.spiHandles.remove(handle);
        }
        return result;
    }

    @Override
    public int spiWrite(int handle, byte[] data, int offset, int length) {
        this.logger.trace("[SPI::WRITE] -> [{}]; Serial Write [{} bytes]", (Object)handle, (Object)data.length);
        this.validateReady();
        this.validateHandle(handle);
        Objects.checkFromIndexSize(offset, length, data.length);
        this.validateHandle(handle);
        int result = PIGPIO.spiWrite(handle, data, offset, length);
        this.logger.trace("[SPI::WRITE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)(result >= 0 ? 1 : 0));
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int spiRead(int handle, byte[] buffer, int offset, int length) {
        this.logger.trace("[SPI::READ] -> [{}]; Serial Read [{} bytes]", (Object)handle, (Object)length);
        this.validateReady();
        this.validateHandle(handle);
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.validateHandle(handle);
        int result = PIGPIO.spiRead(handle, buffer, offset, length);
        boolean success = result >= 0;
        this.logger.trace("[SPI::READ] <- HANDLE={}; SUCCESS={}; BYTES-READ={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }

    @Override
    public int spiXfer(int handle, byte[] write, int writeOffset, byte[] read, int readOffset, int numberOfBytes) {
        this.logger.trace("[SPI::XFER] -> [{}]; Serial Transfer [{} bytes]", (Object)handle, (Object)numberOfBytes);
        this.validateReady();
        this.validateHandle(handle);
        Objects.checkFromIndexSize(writeOffset, numberOfBytes, write.length);
        Objects.checkFromIndexSize(readOffset, numberOfBytes, read.length);
        int result = PIGPIO.spiXfer(handle, write, writeOffset, read, readOffset, numberOfBytes);
        boolean success = result >= 0;
        this.logger.trace("[SPI::XFER] <- HANDLE={}; SUCCESS={}; BYTES-READ={}", new Object[]{handle, success, result});
        this.validateResult(result, false);
        return result;
    }
}

