/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.impl;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioCmd;
import com.pi4j.library.pigpio.PiGpioException;
import com.pi4j.library.pigpio.PiGpioPacket;
import com.pi4j.library.pigpio.impl.PiGpioBase;
import com.pi4j.library.pigpio.impl.PiGpioSocketMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PiGpioSocketBase
extends PiGpioBase
implements PiGpio {
    private static final Logger logger = LoggerFactory.getLogger(PiGpioSocketBase.class);
    protected final PiGpioSocketMonitor monitor;
    protected String host = "127.0.0.1";
    protected int port = 8888;
    protected boolean connected = false;
    protected Socket socket = null;

    protected PiGpioSocketBase(String host, int port) {
        this.host = host;
        this.port = port;
        this.connected = false;
        this.initialized = false;
        this.monitor = new PiGpioSocketMonitor(this);
    }

    @Override
    public int gpioInitialise() {
        int result = 0;
        logger.trace("[INITIALIZE] -> STARTED");
        if (!this.initialized) {
            this.initialized = true;
            result = this.gpioVersion();
            logger.debug("[INITIALIZE] -- INITIALIZED SUCCESSFULLY");
        } else {
            logger.warn("[INITIALIZE] -- ALREADY INITIALIZED");
        }
        logger.trace("[INITIALIZE] <- FINISHED");
        return result;
    }

    @Override
    public void gpioTerminate() {
        logger.trace("[SHUTDOWN] -> STARTED");
        if (this.initialized) {
            this.closeAllOpenHandles();
            if (this.monitor != null && this.monitor.isConnected()) {
                this.monitor.shutdown();
            }
        }
        if (this.socket != null && this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new PiGpioException(e);
            }
        }
        this.initialized = false;
        logger.trace("[SHUTDOWN] <- FINISHED");
    }

    protected PiGpioPacket sendCommand(PiGpioCmd cmd) {
        return this.sendPacket(new PiGpioPacket(cmd));
    }

    protected PiGpioPacket sendCommand(PiGpioCmd cmd, int p1) {
        return this.sendPacket(new PiGpioPacket(cmd, p1));
    }

    protected PiGpioPacket sendCommand(PiGpioCmd cmd, int p1, int p2) {
        return this.sendPacket(new PiGpioPacket(cmd, p1, p2));
    }

    protected PiGpioPacket sendPacket(PiGpioPacket tx) {
        this.validateReady();
        return this.sendPacket(tx, this.socket);
    }

    protected PiGpioPacket sendPacket(PiGpioPacket tx, Socket sck) {
        try {
            try {
                InputStream in = sck.getInputStream();
                OutputStream out = sck.getOutputStream();
                logger.trace("[TX] -> " + tx.toString());
                out.write(PiGpioPacket.encode(tx));
                out.flush();
                int millis = 0;
                try {
                    while (in.available() < 16) {
                        if (millis > 500) {
                            throw new PiGpioException("Command timed out; no response from host in 500 milliseconds");
                        }
                        millis += 5;
                        Thread.sleep(5L);
                    }
                }
                catch (Exception e) {
                    throw new PiGpioException(e.getMessage(), e);
                }
                PiGpioPacket rx = PiGpioPacket.decode(in);
                logger.trace("[RX] <- " + rx.toString());
                return rx;
            }
            catch (SocketException se) {
                this.connected = false;
                this.socket.close();
                this.socket = null;
                throw new PiGpioException(se);
            }
        }
        catch (IOException e) {
            throw new PiGpioException(e);
        }
    }

    @Override
    public void gpioNotifications(int pin, boolean enabled) {
        logger.trace("[GPIO] -> {} Pin [{}] Notifications", (Object)(enabled ? "ENABLE" : "DISABLE"), (Object)pin);
        this.validateReady();
        this.monitor.enable(pin, enabled);
        logger.trace("[GPIO] <- Pin [PIN {}] Notifications [{}]", (Object)pin, (Object)(enabled ? "ENABLED" : "DISABLED"));
    }

    protected void disableNotifications() {
        logger.trace("[GPIO] -> DISABLE ALL Pin Notifications");
        this.validateReady();
        this.monitor.disable();
        logger.trace("[GPIO] <- All Pin Notifications are DISABLED");
    }

    @Override
    protected void validateReady() {
        super.validateReady();
        this.validateConnection();
    }

    protected void validateConnection() {
        if (this.socket == null || !this.connected) {
            try {
                this.socket = new Socket(this.host, this.port);
            }
            catch (IOException e) {
                throw new PiGpioException(e);
            }
            this.connected = this.socket.isConnected();
        }
    }
}

