/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.impl;

import com.pi4j.library.pigpio.PiGpioCmd;
import com.pi4j.library.pigpio.PiGpioPacket;
import com.pi4j.library.pigpio.PiGpioState;
import com.pi4j.library.pigpio.PiGpioStateChangeEvent;
import com.pi4j.library.pigpio.impl.PiGpioSocketBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioSocketMonitor {
    private static final Logger logger = LoggerFactory.getLogger(PiGpioSocketMonitor.class);
    public static String NAME = "pigpio-monitor";
    protected final PiGpioSocketBase piGpio;
    protected Socket listener = null;
    protected boolean shutdown = false;
    protected Integer handle = null;
    protected Thread monitoringThread = null;
    protected int pinState = 0;
    protected int pinMonitor = 0;

    public PiGpioSocketMonitor(PiGpioSocketBase piGpio) {
        this.piGpio = piGpio;
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.disable();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.listener != null && this.listener.isConnected();
    }

    public void enable(int pin, boolean enabled) {
        this.pinMonitor = enabled ? (this.pinMonitor |= 1 << pin) : (this.pinMonitor &= ~(1 << pin));
        if (this.pinMonitor != 0) {
            if (this.monitoringThread == null || !this.monitoringThread.isAlive()) {
                this.startMonitoringThread();
            } else {
                PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.NB, this.handle, this.pinMonitor);
                this.piGpio.sendPacket(tx);
            }
        }
    }

    protected void disable() {
        this.pinMonitor = 0;
        logger.trace("[NOTIFY] disable pin notifications [NB] <ALL PINS 0-31>");
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.NB, this.handle, this.pinMonitor);
        this.piGpio.sendPacket(tx);
        logger.trace("[NOTIFY] disable socket notifications [NC]; HANDLE={}", (Object)this.handle);
        tx = new PiGpioPacket(PiGpioCmd.NC, this.handle);
        this.piGpio.sendPacket(tx);
    }

    private void startMonitoringThread() {
        this.monitoringThread = new Thread(NAME){

            @Override
            public void run() {
                logger.trace("[THREAD] STARTED");
                block11: while (!PiGpioSocketMonitor.this.shutdown && PiGpioSocketMonitor.this.pinMonitor > 0) {
                    try {
                        logger.debug("[SOCKET] attempting to connect to: {}:{}", (Object)PiGpioSocketMonitor.this.piGpio.host, (Object)PiGpioSocketMonitor.this.piGpio.port);
                        PiGpioSocketMonitor.this.listener = new Socket(PiGpioSocketMonitor.this.piGpio.host, PiGpioSocketMonitor.this.piGpio.port);
                        PiGpioSocketMonitor.this.listener.setSoTimeout(1000);
                        if (PiGpioSocketMonitor.this.listener.isConnected()) {
                            logger.debug("[SOCKET] successfully connected");
                            PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.BR1);
                            PiGpioPacket rx = PiGpioSocketMonitor.this.piGpio.sendPacket(tx, PiGpioSocketMonitor.this.listener);
                            PiGpioSocketMonitor.this.pinState = rx.p3();
                            logger.trace("[GPIO] current pin states [BR1] <{}>", (Object)Integer.toBinaryString(PiGpioSocketMonitor.this.pinState));
                            tx = new PiGpioPacket(PiGpioCmd.NOIB);
                            rx = PiGpioSocketMonitor.this.piGpio.sendPacket(tx, PiGpioSocketMonitor.this.listener);
                            PiGpioSocketMonitor.this.handle = rx.p3();
                            logger.trace("[NOTIFY] enable socket notifications [NOIB]; HANDLE={}", (Object)PiGpioSocketMonitor.this.handle);
                            tx = new PiGpioPacket(PiGpioCmd.NB, PiGpioSocketMonitor.this.handle, PiGpioSocketMonitor.this.pinMonitor);
                            PiGpioSocketMonitor.this.piGpio.sendPacket(tx, PiGpioSocketMonitor.this.listener);
                            logger.trace("[NOTIFY] enable pin notifications [NB] <{}>", (Object)Integer.toBinaryString(PiGpioSocketMonitor.this.pinMonitor));
                            InputStream in = PiGpioSocketMonitor.this.listener.getInputStream();
                            boolean disconnected = false;
                            byte[] raw = new byte[12];
                            while (!disconnected && !PiGpioSocketMonitor.this.shutdown && PiGpioSocketMonitor.this.pinMonitor != 0) {
                                try {
                                    int result = in.read(raw, 0, raw.length);
                                    if (result == -1) {
                                        logger.warn("[SOCKET] failed to read socket stream; socket is not connected.");
                                        disconnected = true;
                                        if (PiGpioSocketMonitor.this.listener.isClosed()) break;
                                        PiGpioSocketMonitor.this.listener.close();
                                        break;
                                    }
                                    if (result < 12) continue;
                                    ByteBuffer buffer = ByteBuffer.wrap(raw);
                                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                                    long sequence = Integer.toUnsignedLong(buffer.getShort());
                                    long flags = Integer.toUnsignedLong(buffer.getShort());
                                    long tick = Integer.toUnsignedLong(buffer.getInt());
                                    int newPinState = buffer.getInt();
                                    logger.trace("[NOTIFY] SEQ={}; FLAGS={}; TICK={}; STATES=[{}]", new Object[]{sequence, flags, tick, Integer.toBinaryString(newPinState)});
                                    for (int i = 0; i < 32; ++i) {
                                        int newState;
                                        int oldState;
                                        int pinNotify = PiGpioSocketMonitor.this.pinMonitor >> i & 1;
                                        if (pinNotify <= 0 || (oldState = PiGpioSocketMonitor.this.pinState >> i & 1) == (newState = newPinState >> i & 1)) continue;
                                        PiGpioState state = PiGpioState.from(newState);
                                        PiGpioStateChangeEvent event = new PiGpioStateChangeEvent(i, state, tick);
                                        logger.trace("[DISPATCH] PiGpioStateChangeEvent(PIN={}; FLAGS={}; TICK={}; STATE=[{}]", new Object[]{i, flags, tick, Integer.toBinaryString(newPinState)});
                                        try {
                                            PiGpioSocketMonitor.this.piGpio.dispatchEvent(event);
                                            continue;
                                        }
                                        catch (Exception e) {
                                            logger.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    PiGpioSocketMonitor.this.pinState = newPinState;
                                }
                                catch (SocketTimeoutException socketTimeoutException) {}
                            }
                            if (!disconnected) {
                                logger.trace("[NOTIFY] disable pin notifications [NB] <ALL PINS 0-31>");
                                tx = new PiGpioPacket(PiGpioCmd.NB, PiGpioSocketMonitor.this.handle, 0);
                                PiGpioSocketMonitor.this.piGpio.sendPacket(tx, PiGpioSocketMonitor.this.listener);
                                logger.trace("[NOTIFY] disable socket notifications [NC]; HANDLE={}", (Object)PiGpioSocketMonitor.this.handle);
                                tx = new PiGpioPacket(PiGpioCmd.NC, PiGpioSocketMonitor.this.handle);
                                PiGpioSocketMonitor.this.piGpio.sendPacket(tx, PiGpioSocketMonitor.this.listener);
                            }
                        } else {
                            logger.warn("[SOCKET] Listener socket failed to connect");
                        }
                    }
                    catch (SocketException tx) {
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    PiGpioSocketMonitor.this.handle = null;
                    if (!PiGpioSocketMonitor.this.listener.isClosed()) {
                        try {
                            PiGpioSocketMonitor.this.listener.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (PiGpioSocketMonitor.this.shutdown || PiGpioSocketMonitor.this.pinMonitor <= 0) continue;
                    try {
                        logger.debug("[SOCKET] will attempt to reconnect in 5 seconds");
                        for (int i = 0; i < 50; ++i) {
                            Thread.sleep(100L);
                            if (PiGpioSocketMonitor.this.shutdown) continue block11;
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.debug("[THREAD] ENDED");
            }
        };
        this.monitoringThread.start();
    }
}

