/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.impl;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioCmd;
import com.pi4j.library.pigpio.PiGpioException;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.library.pigpio.PiGpioPacket;
import com.pi4j.library.pigpio.PiGpioPud;
import com.pi4j.library.pigpio.PiGpioState;
import com.pi4j.library.pigpio.impl.PiGpioSocketBase;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioSocketImpl
extends PiGpioSocketBase
implements PiGpio {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public static PiGpio newInstance(String host, String port) {
        return new PiGpioSocketImpl(host, Integer.parseInt(port));
    }

    public static PiGpio newInstance(String host, int port) {
        return new PiGpioSocketImpl(host, port);
    }

    public static PiGpio newInstance(String host) {
        return new PiGpioSocketImpl(host, 8888);
    }

    public static PiGpio newInstance() {
        return new PiGpioSocketImpl("127.0.0.1", 8888);
    }

    private PiGpioSocketImpl(String host, int port) {
        super(host, port);
    }

    @Override
    public int gpioVersion() {
        this.logger.trace("[VERSION] -> GET VERSION");
        this.validateReady();
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PIGPV);
        int version = result.result();
        this.logger.trace("[VERSION] <- RESULT={}", (Object)version);
        return version;
    }

    @Override
    public long gpioHardwareRevision() {
        this.logger.trace("[HARDWARE] -> GET REVISION");
        this.validateReady();
        PiGpioPacket result = this.sendCommand(PiGpioCmd.HWVER);
        long revision = result.result();
        this.logger.trace("[HARDWARE] <- REVISION: {}", (Object)revision);
        if (revision <= 0L) {
            throw new PiGpioException("Hardware revision could not be determined.");
        }
        return revision;
    }

    @Override
    public void gpioSetPullUpDown(int pin, PiGpioPud pud) {
        this.logger.trace("[GPIO::PUD-SET] -> PIN: {}; PUD={}({});", new Object[]{pin, pud.name(), pud.value()});
        this.validateReady();
        this.validatePin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PUD, pin, pud.value());
        this.logger.trace("[GPIO::PUD-SET] <- PIN: {}; PUD={}({}); SUCCESS={}", new Object[]{pud.name(), pud.value(), result.success()});
        this.validateResult(result);
    }

    @Override
    public PiGpioMode gpioGetMode(int pin) {
        this.logger.trace("[GPIO::MODE-GET] -> PIN: {};", (Object)pin);
        this.validateReady();
        this.validatePin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.MODEG, pin);
        this.validateResult(result);
        PiGpioMode mode = PiGpioMode.from(result.result());
        this.logger.trace("[GPIO::MODE-GET] <- PIN: {}; MODE={}({})", new Object[]{pin, mode.name(), mode.value()});
        return mode;
    }

    @Override
    public void gpioSetMode(int pin, PiGpioMode mode) {
        this.logger.trace("[GPIO::MODE-SET] -> PIN: {}; MODE={}({});", new Object[]{pin, mode.name(), mode.value()});
        this.validateReady();
        this.validatePin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.MODES, pin, mode.value());
        this.logger.trace("[GPIO::MODE-SET] <- PIN: {}; MODE={}({}); SUCCESS={}", new Object[]{mode.name(), mode.value(), result.success()});
        this.validateResult(result);
    }

    @Override
    public PiGpioState gpioRead(int pin) {
        this.logger.trace("[GPIO::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validatePin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.READ, pin);
        this.validateResult(result);
        PiGpioState state = PiGpioState.from(result.p3());
        this.logger.trace("[GPIO::GET] <- PIN: {} is {}({})", new Object[]{pin, state.name(), state.value()});
        return state;
    }

    @Override
    public void gpioWrite(int pin, PiGpioState state) {
        this.logger.trace("[GPIO::SET] -> PIN: {}; {}({});", new Object[]{pin, state.name(), state.value()});
        this.validateReady();
        this.validatePin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.WRITE, pin, state.value());
        this.logger.trace("[GPIO::SET] <- PIN: {}; {}({}); SUCCESS={}", new Object[]{pin, state.name(), state.value(), result.success()});
        this.validateResult(result);
    }

    @Override
    public void gpioGlitchFilter(int pin, int steady) {
        this.logger.trace("[GPIO::GLITCH] -> PIN: {}; INTERVAL: {};", (Object)pin, (Object)steady);
        this.validateReady();
        this.validatePin(pin);
        this.validateGpioGlitchFilter(steady);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.FG, pin, steady);
        this.logger.trace("[GPIO::GLITCH] <- PIN: {}; SUCCESS={}", (Object)pin, (Object)result.success());
        this.validateResult(result);
    }

    @Override
    public void gpioNoiseFilter(int pin, int steady, int active) {
        this.logger.trace("[GPIO::NOISE] -> PIN: {}; INTERVAL: {};", (Object)pin, (Object)steady);
        this.validateReady();
        this.validatePin(pin);
        this.validateGpioNoiseFilter(steady, active);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.FN, pin, steady).data(active);
        this.logger.trace("[GPIO::NOISE] <- PIN: {}; SUCCESS={}", (Object)pin, (Object)result.success());
        this.validateResult(result);
    }

    @Override
    public void gpioPWM(int pin, int dutyCycle) {
        this.logger.trace("[PWM::SET] -> PIN: {}; DUTY-CYCLE={};", (Object)pin, (Object)dutyCycle);
        this.validateReady();
        this.validateUserPin(pin);
        this.validateDutyCycle(dutyCycle);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PWM, pin, dutyCycle);
        this.logger.trace("[PWM::SET] <- PIN: {}; DUTY-CYCLE={}; SUCCESS={}", new Object[]{pin, dutyCycle, result.success()});
        this.validateResult(result);
    }

    @Override
    public int gpioGetPWMdutycycle(int pin) {
        this.logger.trace("[PWM::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.GDC, pin);
        int dutyCycle = result.result();
        this.logger.trace("[PWM::GET] <- PIN: {}; DUTY-CYCLE={}; SUCCESS={}", new Object[]{pin, dutyCycle, result.success()});
        this.validateResult(result);
        return dutyCycle;
    }

    @Override
    public int gpioSetPWMrange(int pin, int range) {
        this.logger.trace("[PWM-RANGE::SET] -> PIN: {}; RANGE={}", (Object)pin, (Object)range);
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PRS, pin, range);
        int readRange = result.result();
        this.logger.trace("[PWM-RANGE::SET] <- PIN: {}; REAL-RANGE={}; SUCCESS={}", new Object[]{pin, readRange, result.success()});
        this.validateResult(result);
        return result.result();
    }

    @Override
    public int gpioGetPWMrange(int pin) {
        this.logger.trace("[PWM-RANGE::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PRG, pin);
        int range = result.result();
        this.logger.trace("[PWM-RANGE::GET] <- PIN: {}; RANGE={}; SUCCESS={}", new Object[]{pin, range, result.success()});
        this.validateResult(result);
        return range;
    }

    @Override
    public int gpioGetPWMrealRange(int pin) {
        this.logger.trace("[PWM-REAL-RANGE::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PRRG, pin);
        int range = result.result();
        this.logger.trace("[PWM-REAL-RANGE::GET] <- PIN: {}; RANGE={}; SUCCESS={}", new Object[]{pin, range, result.success()});
        this.validateResult(result);
        return range;
    }

    @Override
    public int gpioSetPWMfrequency(int pin, int frequency) {
        this.logger.trace("[PWM-FREQ::SET] -> PIN: {}; FREQUENCY={}", (Object)pin, (Object)frequency);
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PFS, pin, frequency);
        int actualRange = result.result();
        this.logger.trace("[PWM-FREQ::SET] <- PIN: {}; FREQUENCY={}; SUCCESS={}", new Object[]{pin, frequency, result.success()});
        this.validateResult(result);
        return actualRange;
    }

    @Override
    public int gpioGetPWMfrequency(int pin) {
        this.logger.trace("[PWM-FREQ::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.PFG, pin);
        int frequency = result.result();
        this.logger.trace("[PWM-FREQ::GET] <- PIN: {}; FREQUENCY={}; SUCCESS={}", new Object[]{pin, frequency, result.success()});
        this.validateResult(result);
        return frequency;
    }

    @Override
    public void gpioHardwarePWM(int pin, int frequency, int dutyCycle) {
        this.logger.trace("[HW-PWM::SET] -> PIN: {}; FREQUENCY={}; DUTY-CYCLE={}", new Object[]{pin, frequency, dutyCycle});
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.HP, pin, frequency).data(dutyCycle);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[HW-PWM::SET] <- PIN: {}; SUCCESS={}", (Object)pin, (Object)rx.success());
        this.validateResult(rx);
    }

    @Override
    public void gpioServo(int pin, int pulseWidth) {
        this.logger.trace("[SERVO::SET] -> PIN: {}; PULSE-WIDTH={};", (Object)pin, (Object)pulseWidth);
        this.validateReady();
        this.validateUserPin(pin);
        this.validatePulseWidth(pulseWidth);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.SERVO, pin, pulseWidth);
        this.logger.trace("[SERVO::SET] <- PIN: {}; PULSE-WIDTH={}; SUCCESS={}", new Object[]{pin, pulseWidth, result.success()});
        this.validateResult(result);
    }

    @Override
    public int gpioGetServoPulsewidth(int pin) {
        this.logger.trace("[SERVO::GET] -> PIN: {}", (Object)pin);
        this.validateReady();
        this.validateUserPin(pin);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.GPW, pin);
        int pulseWidth = result.result();
        this.logger.trace("[SERVO::GET] <- PIN: {}; PULSE-WIDTH={}; SUCCESS={}", new Object[]{pin, pulseWidth, result.success()});
        this.validateResult(result);
        return pulseWidth;
    }

    @Override
    public long gpioDelay(long micros) {
        this.logger.trace("[DELAY] -> MICROS: {}", (Object)micros);
        this.validateReady();
        this.validateDelayMicroseconds(micros);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.MICS, (int)micros);
        this.logger.trace("[DELAY] <- MICROS: {}; SUCCESS={}", (Object)micros, (Object)result.success());
        this.validateResult(result);
        return micros;
    }

    @Override
    public int gpioDelayMilliseconds(int millis) {
        this.logger.trace("[DELAY] -> MILLIS: {}", (Object)millis);
        this.validateReady();
        this.validateDelayMilliseconds(millis);
        PiGpioPacket result = this.sendCommand(PiGpioCmd.MILS, millis);
        this.logger.trace("[DELAY] <- MILLIS: {}; SUCCESS={}", (Object)millis, (Object)result.success());
        this.validateResult(result);
        return millis;
    }

    @Override
    public long gpioTick() {
        this.logger.trace("[TICK::GET] -> Get current tick");
        this.validateReady();
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.TICK);
        PiGpioPacket rx = this.sendPacket(tx);
        long tick = Integer.toUnsignedLong(rx.result());
        this.logger.trace("[TICK::GET] <- TICK: {}; SUCCESS={}", (Object)tick, (Object)rx.success());
        return tick;
    }

    @Override
    public int i2cOpen(int bus, int device, int flags) {
        this.logger.trace("[I2C::OPEN] -> Open I2C Bus [{}] and Device [{}]; flags={}", new Object[]{bus, device, flags});
        this.validateReady();
        this.validateI2cBus(bus);
        this.validateI2cDeviceAddress(device);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CO, bus, device).data(flags);
        PiGpioPacket rx = this.sendPacket(tx);
        int handle = rx.result();
        this.logger.trace("[I2C::OPEN] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        if (rx.success()) {
            this.i2cHandles.add(handle);
        }
        return handle;
    }

    @Override
    public int i2cClose(int handle) {
        this.logger.trace("[I2C::CLOSE] -> HANDLE={}, Close I2C Bus", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CC, handle);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::CLOSE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        if (rx.success()) {
            this.i2cHandles.remove(handle);
        }
        return rx.result();
    }

    @Override
    public int i2cWriteQuick(int handle, boolean bit) {
        this.logger.trace("[I2C::WRITE] -> HANDLE={}; R/W Bit [{}]", (Object)handle, (Object)(bit ? 1 : 0));
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CWQ, handle, bit ? 1 : 0);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cWriteByte(int handle, byte value) {
        this.logger.trace("[I2C::WRITE] -> HANDLE={}; Byte [{}]", (Object)handle, (Object)Byte.toUnsignedInt(value));
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CWS, handle, Byte.toUnsignedInt(value));
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cReadByte(int handle) {
        this.logger.trace("[I2C::READ] -> [{}]; Byte", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CRS, handle);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cWriteByteData(int handle, int register, byte value) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; Byte [{}]", new Object[]{handle, register, Byte.toUnsignedInt(value)});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CWB, handle, register).data(Byte.toUnsignedInt(value));
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cWriteWordData(int handle, int register, int value) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; Word [{}]", new Object[]{handle, register, value});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CWW, handle, register).data(value);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cReadByteData(int handle, int register) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; Byte", (Object)handle, (Object)register);
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CRB, handle, register);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cReadWordData(int handle, int register) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; Word", (Object)handle, (Object)register);
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CRW, handle, register);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cProcessCall(int handle, int register, int value) {
        this.logger.trace("[I2C::W/R] -> [{}]; Register [{}]; Word [{}]", new Object[]{handle, register, value});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CPC, handle, register).data(value);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::W/R] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cWriteBlockData(int handle, int register, byte[] data, int offset, int length) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, data.length);
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        this.validateI2cBlockLength(length);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CWK, handle, register).data(data, offset, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cReadBlockData(int handle, int register, byte[] buffer, int offset, int length) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CRK, handle, register);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        if (rx.success()) {
            int actual = rx.result();
            if (rx.dataLength() < actual) {
                actual = rx.dataLength();
            }
            System.arraycopy(rx.data(), 0, buffer, offset, actual);
        }
        return rx.result();
    }

    @Override
    public int i2cBlockProcessCall(int handle, int register, byte[] write, int writeOffset, int writeLength, byte[] read, int readOffset) {
        this.logger.trace("[I2C::W/R] -> [{}]; Register [{}]; Block [{} bytes]; woff={}; roff={}", new Object[]{handle, register, writeLength, writeOffset, readOffset});
        this.validateReady();
        Objects.checkFromIndexSize(writeOffset, writeLength, write.length);
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        this.validateI2cBlockLength(writeLength);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CPK, handle, register).data(write, writeOffset, writeLength);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::W/R] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        if (rx.success()) {
            int readLength = rx.result();
            if (rx.dataLength() < readLength) {
                readLength = rx.dataLength();
            }
            Objects.checkFromIndexSize(readOffset, readLength, read.length);
            System.arraycopy(rx.data(), 0, read, readOffset, readLength);
        }
        return rx.result();
    }

    @Override
    public int i2cBlockProcessCall(int handle, int register, byte[] data, int offset, int length) {
        return this.i2cBlockProcessCall(handle, register, data, offset, length, data, offset);
    }

    @Override
    public int i2cReadI2CBlockData(int handle, int register, byte[] buffer, int offset, int length) {
        this.logger.trace("[I2C::READ] -> [{}]; Register [{}]; I2C Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CRI, handle, register).data(length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        if (rx.success()) {
            try {
                int actual = rx.result();
                if (rx.dataLength() < actual) {
                    actual = rx.dataLength();
                }
                System.arraycopy(rx.data(), 0, buffer, offset, actual);
            }
            catch (ArrayIndexOutOfBoundsException a) {
                this.logger.error(a.getMessage(), (Throwable)a);
            }
        }
        return rx.result();
    }

    @Override
    public int i2cWriteI2CBlockData(int handle, int register, byte[] data, int offset, int length) {
        this.logger.trace("[I2C::WRITE] -> [{}]; Register [{}]; I2C Block [{} bytes]; offset={}", new Object[]{handle, register, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        this.validateI2cRegister(register);
        this.validateI2cBlockLength(length);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CWI, handle, register).data(data, offset, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int i2cReadDevice(int handle, byte[] buffer, int offset, int length) {
        this.logger.trace("[I2C::READ] -> [{}]; I2C Raw Read [{} bytes]; offset={}", new Object[]{handle, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CRD, handle, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::READ] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        if (rx.success()) {
            int actual = rx.result();
            if (rx.dataLength() < actual) {
                actual = rx.dataLength();
            }
            System.arraycopy(rx.data(), 0, buffer, offset, actual);
        }
        return rx.result();
    }

    @Override
    public int i2cWriteDevice(int handle, byte[] data, int offset, int length) {
        this.logger.trace("[I2C::WRITE] -> [{}]; I2C Raw Write [{} bytes]; offset={}", new Object[]{handle, length, offset});
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.I2CWD, handle).data(data, offset, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[I2C::WRITE] <- HANDLE={}; SUCCESS={}; RESULT={}", new Object[]{handle, rx.success(), rx.result()});
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int serOpen(CharSequence device, int baud, int flags) {
        this.logger.trace("[SERIAL::OPEN] -> Open Serial Port [{}] at Baud Rate [{}]", (Object)device, (Object)baud);
        this.validateReady();
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERO, baud, flags).data(device);
        PiGpioPacket rx = this.sendPacket(tx);
        int handle = rx.result();
        this.logger.trace("[SERIAL::OPEN] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        if (rx.success()) {
            this.serialHandles.add(handle);
        }
        return handle;
    }

    @Override
    public int serClose(int handle) {
        this.logger.trace("[SERIAL::CLOSE] -> HANDLE={}, Close Serial Port", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERC, handle);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SERIAL::CLOSE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        if (rx.success()) {
            this.serialHandles.remove(handle);
        }
        return rx.result();
    }

    @Override
    public int serWriteByte(int handle, byte value) {
        this.logger.trace("[SERIAL::WRITE] -> HANDLE={}; Byte [{}]", (Object)handle, (Object)Byte.toUnsignedInt(value));
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERWB, handle, Byte.toUnsignedInt(value));
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SERIAL::WRITE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        return 0;
    }

    @Override
    public int serReadByte(int handle) {
        this.logger.trace("[SERIAL::READ] -> [{}]; Byte", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERRB, handle);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SERIAL::READ] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.p3());
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int serWrite(int handle, byte[] data, int offset, int length) {
        this.logger.trace("[SERIAL::WRITE] -> [{}]; Serial Write [{} bytes]", (Object)handle, (Object)data.length);
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, data.length);
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERW, handle).data(data, offset, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SERIAL::WRITE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int serRead(int handle, byte[] buffer, int offset, int length) {
        this.logger.trace("[SERIAL::READ] -> [{}]; Serial Read [{} bytes]", (Object)handle, (Object)length);
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERR, handle, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SERIAL::READ] <- HANDLE={}; SUCCESS={}; BYTES-READ={}", new Object[]{handle, rx.success(), rx.dataLength()});
        this.validateResult(rx, false);
        if (rx.success()) {
            int actual = rx.result();
            if (rx.dataLength() < actual) {
                actual = rx.dataLength();
            }
            System.arraycopy(rx.data(), 0, buffer, offset, actual);
        }
        return rx.result();
    }

    @Override
    public int serDataAvailable(int handle) {
        this.logger.trace("[SERIAL::AVAIL] -> Get number of bytes available to read");
        this.validateReady();
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERDA, handle);
        PiGpioPacket rx = this.sendPacket(tx);
        int available = rx.result();
        this.logger.trace("[SERIAL::AVAIL] <- HANDLE={}; SUCCESS={}; AVAILABLE={}", new Object[]{handle, rx.success(), available});
        this.validateResult(rx, false);
        return available;
    }

    @Override
    public int serDrain(int handle) {
        this.logger.trace("[SERIAL::DRAIN] -> Drain any remaining bytes in serial RX buffer");
        this.validateReady();
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SERDA, handle);
        PiGpioPacket rx = this.sendPacket(tx);
        this.validateResult(rx, false);
        int available = rx.result();
        if (available > 0) {
            tx = new PiGpioPacket(PiGpioCmd.SERR, handle, available);
            rx = this.sendPacket(tx);
            this.validateResult(rx, false);
        }
        this.logger.trace("[SERIAL::DRAIN] <- HANDLE={}; SUCCESS={}; DRAINED={}", new Object[]{handle, rx.success(), rx.result()});
        return available;
    }

    @Override
    public int spiOpen(int channel, int baud, int flags) {
        this.logger.trace("[SPI::OPEN] -> Open SPI Channel [{}] at Baud Rate [{}]; Flags=[{}]", new Object[]{channel, baud, flags});
        this.validateReady();
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SPIO, channel, baud).data(flags);
        PiGpioPacket rx = this.sendPacket(tx);
        int handle = rx.result();
        this.logger.trace("[SPI::OPEN] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        if (rx.success()) {
            this.spiHandles.add(handle);
        }
        return handle;
    }

    @Override
    public int spiClose(int handle) {
        this.logger.trace("[SPI::CLOSE] -> HANDLE={}, Close Serial Port", (Object)handle);
        this.validateReady();
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SPIC, handle);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SPI::CLOSE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        if (rx.success()) {
            this.spiHandles.remove(handle);
        }
        return rx.result();
    }

    @Override
    public int spiWrite(int handle, byte[] data, int offset, int length) {
        this.logger.trace("[SPI::WRITE] -> [{}]; Serial Write [{} bytes]", (Object)handle, (Object)data.length);
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, data.length);
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SPIW, handle).data(data, offset, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SPI::WRITE] <- HANDLE={}; SUCCESS={}", (Object)handle, (Object)rx.success());
        this.validateResult(rx, false);
        return rx.result();
    }

    @Override
    public int spiRead(int handle, byte[] buffer, int offset, int length) {
        this.logger.trace("[SPI::READ] -> [{}]; Serial Read [{} bytes]", (Object)handle, (Object)length);
        this.validateReady();
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SPIR, handle, length);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SPI::READ] <- HANDLE={}; SUCCESS={}; BYTES-READ={}", new Object[]{handle, rx.success(), rx.dataLength()});
        this.validateResult(rx, false);
        if (rx.success()) {
            int actual = rx.result();
            if (rx.dataLength() < actual) {
                actual = rx.dataLength();
            }
            System.arraycopy(rx.data(), 0, buffer, offset, actual);
        }
        return rx.result();
    }

    @Override
    public int spiXfer(int handle, byte[] write, int writeOffset, byte[] read, int readOffset, int numberOfBytes) {
        this.logger.trace("[SPI::XFER] -> [{}]; Serial Transfer [{} bytes]", (Object)handle, (Object)numberOfBytes);
        this.validateReady();
        Objects.checkFromIndexSize(writeOffset, numberOfBytes, write.length);
        Objects.checkFromIndexSize(readOffset, numberOfBytes, read.length);
        this.validateHandle(handle);
        PiGpioPacket tx = new PiGpioPacket(PiGpioCmd.SPIX, handle).data(write, writeOffset, numberOfBytes);
        PiGpioPacket rx = this.sendPacket(tx);
        this.logger.trace("[SPI::XFER] <- HANDLE={}; SUCCESS={}; BYTES-READ={}", new Object[]{handle, rx.success(), rx.dataLength()});
        this.validateResult(rx, false);
        if (rx.success()) {
            int actual = rx.result();
            if (rx.dataLength() < actual) {
                actual = rx.dataLength();
            }
            System.arraycopy(rx.data(), 0, read, readOffset, actual);
        }
        return rx.result();
    }
}

