/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.PiGpio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class InitRemote {
    private static final Logger logger = LoggerFactory.getLogger(InitRemote.class);

    public static void main(String[] args) {
        String loglevel = "INFO";
        String host = "127.0.0.1";
        if (args != null && args.length > 0) {
            if (args.length >= 2) {
                Level lvl = Level.valueOf((String)args[1].toUpperCase());
                loglevel = lvl.name();
            }
            host = args[0];
        }
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", loglevel);
        PiGpio piGpio = PiGpio.newSocketInstance(host);
        logger.info("");
        logger.info("");
        logger.info("-----------------------------------------------------");
        logger.info("-----------------------------------------------------");
        logger.info("Pi4J Library :: PIGPIO (Remote) JNI Wrapper Library");
        logger.info("-----------------------------------------------------");
        logger.info("-----------------------------------------------------");
        int init = piGpio.gpioInitialise();
        if (init < 0) {
            logger.error("ERROR; PIGPIO INIT FAILED; ERROR CODE: " + init);
        } else {
            logger.info("PIGPIO INITIALIZED SUCCESSFULLY");
        }
        logger.info("PIGPIO VERSION   : " + piGpio.gpioVersion());
        logger.info("PIGPIO HARDWARE  : " + Long.toHexString(piGpio.gpioHardwareRevision()));
        piGpio.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
        logger.info("-----------------------------------------------------");
        logger.info("");
        logger.info("");
    }
}

