/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.util.StringUtil;
import java.util.Arrays;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSerial {
    private static final Logger logger = LoggerFactory.getLogger(TestSerial.class);
    private static String SERIAL_DEVICE = "/dev/ttyS0";
    private static int BAUD_RATE = 9600;

    public static void main(String[] args) throws Exception {
        PiGpio piGpio = PiGpio.newNativeInstance();
        piGpio.gpioInitialise();
        logger.info("PIGPIO INITIALIZED");
        logger.info("PIGPIO VERSION   : " + piGpio.gpioVersion());
        logger.info("PIGPIO HARDWARE  : " + piGpio.gpioHardwareRevision());
        int handle = piGpio.serOpen(SERIAL_DEVICE, BAUD_RATE, 0);
        logger.info("PIGPIO SERIAL OPEN  : " + handle);
        if (handle < 0) {
            logger.error("ERROR; SERIAL OPEN FAILED: ERROR CODE: " + handle);
            System.exit(handle);
        }
        logger.info("SERIAL DATA DRAINED  : " + piGpio.serDrain(handle));
        for (int b = 0; b < 256; ++b) {
            int expected;
            int recevied;
            logger.info("[SERIAL W/R BYTE]");
            logger.info(" (WRITE) 0x" + Integer.toHexString(b));
            int result = piGpio.serWriteByte(handle, (byte)b);
            if (result < 0) {
                logger.error("\nERROR; SERIAL WRITE FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            Thread.sleep(5L);
            int available = piGpio.serDataAvailable(handle);
            logger.info(" (AVAIL) " + available);
            if (available != 1) {
                logger.error("\nERROR; SERIAL AVAILABLE FAILED: expected=1; received=" + available);
                System.exit(result);
            }
            result = piGpio.serReadByte(handle);
            logger.info(" (READ) 0x" + Integer.toHexString(result));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; SERIAL READ FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            if ((recevied = result) == (expected = b)) continue;
            logger.error("\nERROR; SERIAL READ FAILED: BYTE MISMATCH: expected=" + expected + "; received=" + recevied);
            System.exit(0);
        }
        for (int x = 1; x < 50; ++x) {
            logger.info("[SERIAL W/R BUFFER]");
            Random r = new Random();
            int len = r.nextInt(20) + 2;
            byte[] writeBuffer = new byte[len];
            r.nextBytes(writeBuffer);
            logger.info(" (WRITE) 0x" + StringUtil.toHexString(writeBuffer));
            int result = piGpio.serWrite(handle, writeBuffer, len);
            if (result < 0) {
                logger.error("\nERROR; SERIAL WRITE FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            Thread.sleep(40L);
            int available = piGpio.serDataAvailable(handle);
            logger.info(" (AVAIL) " + available);
            if (available != len) {
                logger.error("\nERROR; SERIAL AVAILABLE FAILED: expected=1; received=" + available);
                System.exit(result);
            }
            byte[] readBuffer = new byte[available];
            result = piGpio.serRead(handle, readBuffer, available);
            logger.info(" (READ) 0x" + StringUtil.toHexString(readBuffer));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; SERIAL READ FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            if (result != len) {
                logger.error("\nERROR; SERIAL READ FAILED: LENGTH MISMATCH: " + result);
                System.exit(result);
            }
            if (Arrays.equals(writeBuffer, readBuffer)) continue;
            logger.error("\nERROR; SERIAL READ FAILED: BYTE MISMATCH: expected=" + StringUtil.toHexString(writeBuffer) + "; received=" + StringUtil.toHexString(readBuffer));
            System.exit(0);
        }
        int closed = piGpio.serClose(handle);
        logger.info("PIGPIO SERIAL CLOSED : " + handle);
        piGpio.shutdown();
        logger.info("PIGPIO TERMINATED");
        logger.info("ALL SERIAL TESTS COMPLETED SUCCESSFULLY");
    }
}

