/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.internal.PIGPIO;
import com.pi4j.library.pigpio.util.StringUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpiRaw {
    private static final Logger logger = LoggerFactory.getLogger(TestSpiRaw.class);

    public static void main(String[] args) {
        byte[] rx;
        int b;
        logger.info("PIGPIO VERSION   : " + PIGPIO.gpioVersion());
        logger.info("PIGPIO HARDWARE  : " + PIGPIO.gpioHardwareRevision());
        int init = PIGPIO.gpioInitialise();
        logger.info("PIGPIO INITIALIZE: " + init);
        if (init < 0) {
            logger.error("ERROR; PIGPIO INIT FAILED; ERROR CODE: " + init);
            System.exit(init);
        }
        int handle = PIGPIO.spiOpen(0, 50000, 0);
        logger.info("PIGPIO SPI OPEN  : " + handle);
        if (handle < 0) {
            logger.error("ERROR; SPI OPEN FAILED: ERROR CODE: " + handle);
            System.exit(handle);
        }
        for (b = 0; b < 256; ++b) {
            logger.info("[W/R BYTE]");
            logger.info(" (WRITE) 0x" + Integer.toHexString(b));
            int result = PIGPIO.spiWrite(handle, new byte[]{(byte)b}, 1);
            if (result < 0) {
                logger.error("\nERROR; SPI WRITE FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            rx = new byte[1];
            result = PIGPIO.spiRead(handle, rx, 1);
            logger.info(" (READ) 0x" + StringUtil.toHexString(rx));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; SPI READ FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            int expected = b;
            int received = Byte.toUnsignedInt(rx[0]);
            if (received == expected) continue;
            logger.error("\nERROR; SPI READ FAILED: BYTE MISMATCH: expected=" + expected + "; received=" + received);
            System.exit(0);
        }
        for (b = 0; b < 256; ++b) {
            logger.info("[XFER BYTE]");
            byte[] tx = new byte[]{(byte)b};
            rx = new byte[]{0};
            logger.info(" (WRITE) 0x" + StringUtil.toHexString(tx));
            int result = PIGPIO.spiXfer(handle, tx, rx, 1);
            logger.info(" (READ) 0x" + StringUtil.toHexString(rx));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; SPI XFER FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            if (b <= 0) continue;
            int expected = b - 1;
            int received = Byte.toUnsignedInt(rx[0]);
            if (received == expected) continue;
            logger.error("\nERROR; SPI XFER FAILED: BYTE MISMATCH: expected=" + expected + "; received=" + received);
            System.exit(0);
        }
        for (int x = 1; x < 50; ++x) {
            logger.info("[W/R BUFFER]");
            Random r = new Random();
            int len = r.nextInt(20) + 2;
            byte[] writeBuffer = new byte[len];
            r.nextBytes(writeBuffer);
            logger.info(" (WRITE) 0x" + StringUtil.toHexString(writeBuffer));
            int result = PIGPIO.spiWrite(handle, writeBuffer, len);
            if (result < 0) {
                logger.error("\nERROR; SPI WRITE FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            byte[] readBuffer = new byte[len];
            result = PIGPIO.spiRead(handle, readBuffer, len);
            logger.info(" (READ) 0x" + StringUtil.toHexString(readBuffer));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; SPI READ FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            if (result != len) {
                logger.error("\nERROR; SPI READ FAILED: LENGTH MISMATCH: " + result);
                System.exit(result);
            }
            ByteBuffer expectBuffer = ByteBuffer.allocate(len);
            expectBuffer.put(writeBuffer[writeBuffer.length - 1]);
            expectBuffer.put(Arrays.copyOfRange(writeBuffer, 0, writeBuffer.length - 1));
            if (expectBuffer.get(0) == readBuffer[0]) continue;
            logger.error("\nERROR; SPI READ FAILED: BYTE MISMATCH: expected=" + StringUtil.toHexString(expectBuffer) + "; received=" + StringUtil.toHexString(readBuffer));
            System.exit(0);
        }
        PIGPIO.spiClose(handle);
        PIGPIO.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
    }
}

