/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.util.StringUtil;
import java.util.Arrays;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestI2CRegister {
    private static final Logger logger = LoggerFactory.getLogger(TestI2CRegister.class);
    private static int I2C_BUS = 1;
    private static int I2C_DEVICE = 4;
    private static int MAX_REGISTERS = 10;

    public static void main(String[] args) {
        int result;
        int word;
        int b;
        int register;
        PiGpio piGpio = PiGpio.newNativeInstance();
        piGpio.gpioInitialise();
        logger.info("PIGPIO INITIALIZED");
        logger.info("PIGPIO VERSION   : {}", (Object)piGpio.gpioVersion());
        logger.info("PIGPIO HARDWARE  : {}", (Object)piGpio.gpioHardwareRevision());
        int handle = piGpio.i2cOpen(I2C_BUS, I2C_DEVICE, 0);
        logger.info("PIGPIO I2C OPEN  : {}", (Object)handle);
        if (handle < 0) {
            logger.error("ERROR; I2C OPEN FAILED: ERROR CODE: {}", (Object)handle);
            System.exit(handle);
        }
        logger.info("");
        logger.info("----------------------------------------");
        logger.info("TEST I2C REGISTER WRITE/READ BYTE");
        logger.info("----------------------------------------");
        for (register = 0; register < MAX_REGISTERS; ++register) {
            for (b = 0; b < 255; ++b) {
                logger.info("[REG #{}][W/R BYTE]", (Object)register);
                logger.info(" (WRITE) 0x{}", (Object)Integer.toHexString(b));
                int result2 = piGpio.i2cWriteByteData(handle, register, (byte)b);
                if (result2 < 0) {
                    logger.error("\nERROR; I2C WRITE BYTE FAILED: ERROR CODE: {}", (Object)result2);
                    System.exit(result2);
                }
                if ((result2 = piGpio.i2cReadByteData(handle, register)) < 0) {
                    logger.error("\nERROR; I2C READ BYTE FAILED: ERROR CODE: {}", (Object)result2);
                    System.exit(result2);
                }
                logger.info(" (READ) 0x{}", (Object)Integer.toHexString(result2));
                logger.info("");
                int expected = b;
                int received = result2;
                if (received == expected) continue;
                logger.error("\nERROR; I2C READ BYTE FAILED: BYTE MISMATCH: expected={}; received={}", (Object)expected, (Object)received);
                System.exit(0);
            }
        }
        logger.info("");
        logger.info("----------------------------------------");
        logger.info("TEST I2C REGISTER WRITE/READ WORD");
        logger.info("----------------------------------------");
        for (register = 0; register < MAX_REGISTERS; ++register) {
            for (b = 0; b < 100; ++b) {
                logger.info("[REG #{}][W/R WORD]", (Object)register);
                Random rand = new Random();
                word = rand.nextInt(65535);
                logger.info(" (WRITE) 0x{}", (Object)Integer.toHexString(word));
                result = piGpio.i2cWriteWordData(handle, register, word);
                if (result < 0) {
                    logger.error("\nERROR; I2C WRITE WORD FAILED: ERROR CODE: {}", (Object)result);
                    System.exit(result);
                }
                if ((result = piGpio.i2cReadWordData(handle, register)) < 0) {
                    logger.error("\nERROR; I2C READ WORD FAILED: ERROR CODE: {}", (Object)result);
                    System.exit(result);
                }
                logger.info(" (READ) 0x{}", (Object)Integer.toHexString(result));
                logger.info("");
                if (result == word) continue;
                logger.error("\nERROR; I2C READ WORD FAILED: BYTE MISMATCH: expected={}; received={}", (Object)word, (Object)result);
                System.exit(0);
            }
        }
        logger.info("");
        logger.info("----------------------------------------");
        logger.info("TEST I2C REGISTER PROCESS WORD (W/R)    ");
        logger.info("----------------------------------------");
        for (register = 0; register < MAX_REGISTERS; ++register) {
            for (b = 0; b < 100; ++b) {
                logger.info("[REG #{}][XFER WORD]", (Object)register);
                Random rand = new Random();
                word = rand.nextInt(65535);
                logger.info(" (WRITE) 0x{}", (Object)Integer.toHexString(word));
                result = piGpio.i2cProcessCall(handle, register, word);
                if (result < 0) {
                    logger.error("\nERROR; I2C PROCESS WORD FAILED: ERROR CODE: {}", (Object)result);
                    System.exit(result);
                }
                logger.info(" (READ) 0x{}", (Object)Integer.toHexString(result));
                logger.info("");
                if (result == word) continue;
                logger.error("\nERROR; I2C PROCESS WORD FAILED: BYTE MISMATCH: expected={}; received={}", (Object)word, (Object)result);
                System.exit(0);
            }
        }
        logger.info("");
        logger.info("----------------------------------------");
        logger.info("TEST I2C REGISTER WRITE/READ ARRAY      ");
        logger.info("----------------------------------------");
        for (register = 0; register < MAX_REGISTERS; ++register) {
            for (int x = 1; x < 100; ++x) {
                logger.info("[REG #{}][W/R BUFFER]", (Object)register);
                Random r = new Random();
                int len = r.nextInt(20) + 2;
                byte[] writeBuffer = new byte[len];
                r.nextBytes(writeBuffer);
                logger.info(" (WRITE) 0x{}", (Object)StringUtil.toHexString(writeBuffer));
                int result3 = piGpio.i2cWriteI2CBlockData(handle, register, writeBuffer);
                if (result3 < 0) {
                    logger.error("\nERROR; I2C WRITE FAILED: ERROR CODE: {}", (Object)result3);
                    System.exit(result3);
                }
                byte[] readBuffer = new byte[len];
                result3 = piGpio.i2cReadI2CBlockData(handle, register, readBuffer);
                logger.info(" (READ) 0x{}", (Object)StringUtil.toHexString(readBuffer));
                logger.info("");
                if (result3 < 0) {
                    logger.error("\nERROR; I2C READ FAILED: ERROR CODE: {}", (Object)result3);
                    System.exit(result3);
                }
                if (result3 != len) {
                    logger.error("\nERROR; I2C READ FAILED: LENGTH MISMATCH: {}", (Object)result3);
                    System.exit(result3);
                }
                if (Arrays.equals(writeBuffer, readBuffer)) continue;
                logger.error("\nERROR; I2C READ FAILED: BYTE MISMATCH: expected={}; received={}", (Object)StringUtil.toHexString(writeBuffer), (Object)StringUtil.toHexString(readBuffer));
                System.exit(0);
            }
        }
        piGpio.i2cClose(handle);
        piGpio.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
        logger.info("ALL I2C DEVICE REGISTER TESTS COMPLETED SUCCESSFULLY");
    }
}

