/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioMode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestPwmHardware {
    private static final Logger logger = LoggerFactory.getLogger(TestPwmHardware.class);
    public static int GPIO_PIN = 21;

    public static void main(String[] args) throws IOException {
        String loglevel = "INFO";
        if (args != null && args.length > 0) {
            Level lvl = Level.valueOf((String)args[0].toUpperCase());
            loglevel = lvl.name();
        }
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", loglevel);
        logger.info("");
        logger.info("");
        PiGpio piGpio = PiGpio.newNativeInstance();
        piGpio.gpioInitialise();
        logger.info("-----------------------------------------------------");
        logger.info("PIGPIO INITIALIZED SUCCESSFULLY");
        logger.info("-----------------------------------------------------");
        logger.info("PIGPIO VERSION   : {}", (Object)piGpio.gpioVersion());
        logger.info("PIGPIO HARDWARE  : {}", (Object)piGpio.gpioHardwareRevision());
        piGpio.gpioSetMode(19, PiGpioMode.ALT5);
        piGpio.gpioHardwarePWM(19, 1000, 500000);
        System.in.read();
        piGpio.gpioHardwarePWM(19, 0, 500000);
        logger.info("-----------------------------------------------------");
        piGpio.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
        logger.info("-----------------------------------------------------");
        logger.info("");
        logger.info("");
    }
}

