/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio;

import com.pi4j.library.pigpio.PiGpioCmd;
import com.pi4j.library.pigpio.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioPacket {
    private static final Logger logger = LoggerFactory.getLogger(PiGpioPacket.class);
    private PiGpioCmd cmd;
    private int p1 = 0;
    private int p2 = 0;
    private int p3 = 0;
    private byte[] data = new byte[0];

    public PiGpioPacket() {
    }

    public PiGpioPacket(PiGpioCmd cmd) {
        this.cmd(cmd);
    }

    public PiGpioPacket(PiGpioCmd cmd, int p1) {
        this.cmd(cmd).p1(p1);
    }

    public PiGpioPacket(PiGpioCmd cmd, int p1, int p2) {
        this.cmd(cmd).p1(p1).p2(p2);
    }

    public PiGpioPacket(PiGpioCmd cmd, int p1, int p2, byte[] data) {
        this.cmd(cmd).p1(p1).p2(p2).data(data);
    }

    public PiGpioCmd cmd() {
        return this.cmd;
    }

    public PiGpioPacket cmd(PiGpioCmd cmd) {
        this.cmd = cmd;
        return this;
    }

    public int p1() {
        return this.p1;
    }

    public PiGpioPacket p1(int p1) {
        this.p1 = p1;
        return this;
    }

    public int p2() {
        return this.p2;
    }

    public PiGpioPacket p2(int p2) {
        this.p2 = p2;
        return this;
    }

    public int p3() {
        return this.p3;
    }

    protected PiGpioPacket p3(int p3) {
        this.p3 = p3;
        return this;
    }

    public int result() {
        return this.p3();
    }

    public boolean success() {
        return this.p3() >= 0;
    }

    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        return this.data.length > 0;
    }

    public int dataLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public byte[] data() {
        return this.data;
    }

    public PiGpioPacket data(CharSequence data) {
        return this.data(data.toString().getBytes(StandardCharsets.US_ASCII));
    }

    public PiGpioPacket data(byte[] data) {
        return this.data(data, data.length);
    }

    public PiGpioPacket data(byte[] data, int length) {
        return this.data(data, 0, data.length);
    }

    public PiGpioPacket data(byte[] data, int offset, int length) {
        if (data != null && data.length > 0 && length > 0) {
            this.p3 = length;
            this.data = Arrays.copyOfRange(data, offset, offset + length);
        } else {
            this.p3 = 0;
            this.data = new byte[0];
        }
        return this;
    }

    public PiGpioPacket data(int value) {
        if (value > 0) {
            this.p3 = 4;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(value);
            this.data = buffer.array();
        } else {
            this.p3 = 0;
            this.data = new byte[0];
        }
        return this;
    }

    public PiGpioPacket data(byte value) {
        if (value > 0) {
            this.p3 = 4;
            this.data = new byte[]{value, 0, 0, 0};
        } else {
            this.p3 = 0;
            this.data = new byte[0];
        }
        return this;
    }

    public String dataToString() {
        if (this.data == null) {
            return null;
        }
        if (this.data.length == 0) {
            return "";
        }
        return new String(this.data, StandardCharsets.US_ASCII);
    }

    public static PiGpioPacket decode(InputStream stream) throws IOException {
        byte[] header = stream.readNBytes(16);
        ByteBuffer rx = ByteBuffer.wrap(header);
        rx.order(ByteOrder.LITTLE_ENDIAN);
        PiGpioCmd cmd = PiGpioCmd.from(rx.getInt());
        int p1 = rx.getInt();
        int p2 = rx.getInt();
        int p3 = rx.getInt();
        PiGpioPacket packet = new PiGpioPacket(cmd, p1, p2).p3(p3);
        int remaining = PiGpioPacket.bytesToRead(packet, stream);
        if (remaining > 0) {
            byte[] temp = stream.readNBytes(remaining);
            packet.data(temp);
        }
        return packet;
    }

    static int bytesToRead(PiGpioPacket packet, InputStream stream) throws IOException {
        switch (packet.cmd) {
            case I2CRI: 
            case I2CRD: {
                return packet.p3;
            }
        }
        return stream.available();
    }

    public static byte[] encode(PiGpioPacket packet) {
        byte[] bytes = new byte[16 + packet.dataLength()];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(packet.cmd().value());
        buffer.putInt(packet.p1());
        buffer.putInt(packet.p2());
        buffer.putInt(packet.p3());
        if (packet.data != null && packet.data.length > 0) {
            buffer.put(packet.data());
        }
        return bytes;
    }

    public String toString() {
        if (this.p3() > 0) {
            return String.format("CMD=%s(%d); P1=%d; P2=%d; P3=%d; PAYLOAD=[0x%s]", this.cmd().name(), this.cmd().value(), this.p1(), this.p2(), this.p3(), StringUtil.toHexString(this.data()));
        }
        return String.format("CMD=%s(%d); P1=%d; P2=%d; P3=%d", this.cmd().name(), this.cmd().value(), this.p1(), this.p2(), this.p3());
    }
}

