/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.internal.PIGPIO;
import com.pi4j.library.pigpio.util.StringUtil;
import java.util.Arrays;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestI2CRaw {
    private static final Logger logger = LoggerFactory.getLogger(TestI2CRaw.class);
    private static int I2C_BUS = 1;
    private static int I2C_DEVICE = 4;

    public static void main(String[] args) {
        logger.info("PIGPIO VERSION   : {}", (Object)PIGPIO.gpioVersion());
        logger.info("PIGPIO HARDWARE  : {}", (Object)PIGPIO.gpioHardwareRevision());
        int init = PIGPIO.gpioInitialise();
        logger.info("PIGPIO INITIALIZE: {}", (Object)init);
        if (init < 0) {
            logger.error("ERROR; PIGPIO INIT FAILED; ERROR CODE: {}", (Object)init);
            System.exit(init);
        }
        int handle = PIGPIO.i2cOpen(I2C_BUS, I2C_DEVICE, 0);
        logger.info("PIGPIO I2C OPEN  : {}", (Object)handle);
        if (handle < 0) {
            logger.error("ERROR; I2C OPEN FAILED: ERROR CODE: {}", (Object)handle);
            System.exit(handle);
        }
        logger.info("");
        logger.info("----------------------------------------");
        logger.info("TEST I2C SINGLE BYTE RAW READ/WRITE");
        logger.info("----------------------------------------");
        for (int b = 0; b < 255; ++b) {
            logger.info("[W/R BYTE]");
            logger.info(" (WRITE) 0x{}", (Object)Integer.toHexString(b));
            int result = PIGPIO.i2cWriteByte(handle, (byte)b);
            if (result < 0) {
                logger.error("\nERROR; I2C WRITE FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            if ((result = PIGPIO.i2cReadByte(handle)) < 0) {
                logger.error("\nERROR; I2C READ FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            logger.info(" (READ) 0x{}", (Object)Integer.toHexString(result));
            logger.info("");
            int expected = b;
            int received = result;
            if (received == expected) continue;
            logger.error("\nERROR; I2C READ FAILED: BYTE MISMATCH: expected={}; received={}", (Object)expected, (Object)received);
            System.exit(0);
        }
        for (int x = 1; x < 100; ++x) {
            logger.info("[W/R BUFFER]");
            Random r = new Random();
            int len = r.nextInt(20) + 2;
            byte[] writeBuffer = new byte[len];
            r.nextBytes(writeBuffer);
            logger.info(" (WRITE) 0x{}", (Object)StringUtil.toHexString(writeBuffer));
            int result = PIGPIO.i2cWriteDevice(handle, writeBuffer, len);
            if (result < 0) {
                logger.error("\nERROR; I2C WRITE FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            byte[] readBuffer = new byte[len];
            result = PIGPIO.i2cReadDevice(handle, readBuffer, len);
            logger.info(" (READ) 0x{}", (Object)StringUtil.toHexString(readBuffer));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; I2C READ FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            if (result != len) {
                logger.error("\nERROR; I2C READ FAILED: LENGTH MISMATCH: {}", (Object)result);
                System.exit(result);
            }
            if (Arrays.equals(writeBuffer, readBuffer)) continue;
            logger.error("\nERROR; I2C READ FAILED: BYTE MISMATCH: expected={}; received={}", (Object)StringUtil.toHexString(writeBuffer), (Object)StringUtil.toHexString(readBuffer));
            System.exit(0);
        }
        PIGPIO.i2cClose(handle);
        PIGPIO.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
        logger.info("ALL I2C RAW DEVICE TESTS COMPLETED SUCCESSFULLY");
    }
}

