/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.internal.PIGPIO;
import com.pi4j.library.pigpio.util.StringUtil;
import java.util.Arrays;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSerialRaw {
    private static final Logger logger = LoggerFactory.getLogger(TestSerialRaw.class);
    private static String SERIAL_DEVICE = "/dev/ttyS0";
    private static int BAUD_RATE = 9600;

    public static void main(String[] args) throws InterruptedException {
        logger.info("PIGPIO VERSION   : {}", (Object)PIGPIO.gpioVersion());
        logger.info("PIGPIO HARDWARE  : {}", (Object)PIGPIO.gpioHardwareRevision());
        int init = PIGPIO.gpioInitialise();
        logger.info("PIGPIO INITIALIZE: {}", (Object)init);
        if (init < 0) {
            logger.error("ERROR; PIGPIO INIT FAILED; ERROR CODE: {}", (Object)init);
            System.exit(init);
        }
        int handle = PIGPIO.serOpen(SERIAL_DEVICE, BAUD_RATE, 0);
        logger.info("PIGPIO SERIAL OPEN  : {}", (Object)handle);
        if (handle < 0) {
            logger.error("ERROR; SERIAL OPEN FAILED: ERROR CODE: {}", (Object)handle);
            System.exit(handle);
        }
        logger.info("SERIAL DATA DRAINED  : {}", (Object)PIGPIO.serDrain(handle));
        for (int b = 0; b < 256; ++b) {
            int expected;
            int recevied;
            logger.info("[SERIAL W/R BYTE]");
            logger.info(" (WRITE) 0x{}", (Object)Integer.toHexString(b));
            int result = PIGPIO.serWriteByte(handle, (byte)b);
            if (result < 0) {
                logger.error("\nERROR; SERIAL WRITE FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            Thread.sleep(5L);
            int available = PIGPIO.serDataAvailable(handle);
            logger.info(" (AVAIL) {}", (Object)available);
            if (available != 1) {
                logger.error("\nERROR; SERIAL AVAILABLE FAILED: expected=1; received={}", (Object)available);
                System.exit(result);
            }
            result = PIGPIO.serReadByte(handle);
            logger.info(" (READ) 0x{}", (Object)Integer.toHexString(result));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; SERIAL READ FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            if ((recevied = result) == (expected = b)) continue;
            logger.error("\nERROR; SERIAL READ FAILED: BYTE MISMATCH: expected={}; received={}", (Object)expected, (Object)recevied);
            System.exit(0);
        }
        for (int x = 1; x < 50; ++x) {
            logger.info("[SERIAL W/R BUFFER]");
            Random r = new Random();
            int len = r.nextInt(20) + 4;
            byte[] writeBuffer = new byte[len];
            r.nextBytes(writeBuffer);
            logger.info(" (WRITE) 0x{}", (Object)StringUtil.toHexString(writeBuffer));
            int result = PIGPIO.serWrite(handle, writeBuffer, len);
            if (result < 0) {
                logger.error("\nERROR; SERIAL WRITE FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            Thread.sleep(40L);
            int available = PIGPIO.serDataAvailable(handle);
            logger.info(" (AVAIL) {}", (Object)available);
            if (available != len) {
                logger.error("\nERROR; SERIAL AVAILABLE FAILED: expected=1; received={}", (Object)available);
                System.exit(result);
            }
            byte[] readBuffer = new byte[available];
            result = PIGPIO.serRead(handle, readBuffer, available);
            logger.info(" (READ) 0x{}", (Object)StringUtil.toHexString(readBuffer));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; SERIAL READ FAILED: ERROR CODE: {}", (Object)result);
                System.exit(result);
            }
            if (result != len) {
                logger.error("\nERROR; SERIAL READ FAILED: LENGTH MISMATCH: {}", (Object)result);
                System.exit(result);
            }
            if (Arrays.equals(writeBuffer, readBuffer)) continue;
            logger.error("\nERROR; SERIAL READ FAILED: BYTE MISMATCH: expected={}; received={}", (Object)StringUtil.toHexString(writeBuffer), (Object)StringUtil.toHexString(readBuffer));
            System.exit(0);
        }
        int closed = PIGPIO.serClose(handle);
        logger.info("PIGPIO SERIAL CLOSED : {}", (Object)handle);
        PIGPIO.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
        logger.info("ALL SERIAL TESTS COMPLETED SUCCESSFULLY");
    }
}

