/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.gpiod.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.IO;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalInputProviderBase;
import com.pi4j.library.gpiod.internal.GpioDContext;
import com.pi4j.library.gpiod.internal.GpioLine;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalInput;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalInputProvider;

public class GpioDDigitalInputProviderImpl
extends DigitalInputProviderBase
implements GpioDDigitalInputProvider {
    public GpioDDigitalInputProviderImpl() {
        this.id = "gpiod-digital-input";
        this.name = "GpioD Digital Input (GPIO) Provider";
    }

    public DigitalInput create(DigitalInputConfig config) {
        GpioLine line = GpioDContext.getInstance().getOrOpenLine(config.address().intValue());
        GpioDDigitalInput digitalInput = new GpioDDigitalInput(line, this, config);
        this.context.registry().add((IO)digitalInput);
        return digitalInput;
    }

    public int getPriority() {
        return 150;
    }

    public DigitalInputProvider initialize(Context context) throws InitializeException {
        DigitalInputProvider provider = (DigitalInputProvider)super.initialize(context);
        GpioDContext.getInstance().initialize();
        return provider;
    }

    public DigitalInputProvider shutdown(Context context) throws ShutdownException {
        GpioDContext.getInstance().close();
        return (DigitalInputProvider)super.shutdown(context);
    }
}

