/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.gpiod.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputBase;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.library.gpiod.internal.GpioDContext;
import com.pi4j.library.gpiod.internal.GpioDException;
import com.pi4j.library.gpiod.internal.GpioLine;
import com.pi4j.library.gpiod.internal.LineDirection;

public class GpioDDigitalOutput
extends DigitalOutputBase
implements DigitalOutput {
    private final GpioLine line;

    public GpioDDigitalOutput(GpioLine line, DigitalOutputProvider provider, DigitalOutputConfig config) {
        super(provider, config);
        this.line = line;
    }

    public DigitalOutput initialize(Context context) throws InitializeException {
        try {
            int initialState = ((DigitalOutputConfig)this.config).getInitialState() == null ? DigitalState.LOW.value().intValue() : ((DigitalOutputConfig)this.config).initialState().value().intValue();
            if (this.line.getDirection() == LineDirection.INPUT) {
                GpioDContext.getInstance().closeLine(this.line);
            }
            this.line.requestOutput(((DigitalOutputConfig)this.config).getId(), initialState);
        }
        catch (GpioDException e) {
            throw new InitializeException("Failed to initialize output " + this.id, (Throwable)e);
        }
        super.initialize(context);
        return this;
    }

    public DigitalOutput shutdown(Context context) throws ShutdownException {
        super.shutdown(context);
        return this;
    }

    public DigitalOutput state(DigitalState state) throws IOException {
        try {
            this.line.setValue(state.value().intValue());
        }
        catch (GpioDException e) {
            throw new IOException("Failed to set state for output " + this.id + " to " + String.valueOf(state), (Throwable)e);
        }
        return super.state(state);
    }
}

