/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.gpiod.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.IO;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.gpio.digital.DigitalOutputProviderBase;
import com.pi4j.library.gpiod.internal.GpioDContext;
import com.pi4j.library.gpiod.internal.GpioLine;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalOutput;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalOutputProvider;

public class GpioDDigitalOutputProviderImpl
extends DigitalOutputProviderBase
implements GpioDDigitalOutputProvider {
    public GpioDDigitalOutputProviderImpl() {
        this.id = "gpiod-digital-output";
        this.name = "GpioD Digital Output (GPIO) Provider";
    }

    public DigitalOutput create(DigitalOutputConfig config) {
        GpioLine line = GpioDContext.getInstance().getOrOpenLine(config.address().intValue());
        GpioDDigitalOutput digitalOutput = new GpioDDigitalOutput(line, this, config);
        this.context.registry().add((IO)digitalOutput);
        return digitalOutput;
    }

    public int getPriority() {
        return 150;
    }

    public DigitalOutputProvider initialize(Context context) throws InitializeException {
        DigitalOutputProvider provider = (DigitalOutputProvider)super.initialize(context);
        GpioDContext.getInstance().initialize(context.properties());
        return provider;
    }

    public DigitalOutputProvider shutdown(Context context) throws ShutdownException {
        GpioDContext.getInstance().close();
        return (DigitalOutputProvider)super.shutdown(context);
    }
}

