/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.pi4j.plugin.linuxfs.provider.gpio.LinuxCmd;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        String output = Main.sftp("pi", "rpi3bp", "raspberry", LinuxCmd.export(21));
        logger.info(output);
    }

    public static String sftp(String user, String host, String password, String command1) {
        String CommandOutput = null;
        try {
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            JSch jsch = new JSch();
            Session session = jsch.getSession(user, host, 22);
            session.setPassword(password);
            session.setConfig(config);
            session.connect();
            logger.info("Connected");
            Channel channel = session.openChannel("sftp");
            channel.connect();
            channel.setInputStream(null);
            ChannelSftp c = (ChannelSftp)channel;
            InputStream in = c.get("/dev/pigout");
            logger.info(Arrays.toString(in.readAllBytes()));
            channel.disconnect();
            session.disconnect();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return CommandOutput;
    }

    public static String connectAndExecute(String user, String host, String password, String command1) {
        String CommandOutput = null;
        try {
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            JSch jsch = new JSch();
            Session session = jsch.getSession(user, host, 22);
            session.setPassword(password);
            session.setConfig(config);
            session.connect();
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command1);
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    CommandOutput = new String(tmp, 0, i);
                    continue;
                }
                if (channel.isClosed()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            channel.disconnect();
            session.disconnect();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return CommandOutput;
    }
}

