/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.i2c;

import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CBase;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.plugin.linuxfs.provider.i2c.I2CConstants;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CBus;
import com.pi4j.plugin.linuxfs.util.SystemUtil;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Objects;

public class LinuxFsI2C
extends I2CBase
implements I2C {
    private final LinuxFsI2CBus i2CBus;

    public LinuxFsI2C(LinuxFsI2CBus i2CBus, I2CProvider provider, I2CConfig config) {
        super(provider, config);
        this.i2CBus = i2CBus;
    }

    public int write(byte b) {
        return this.i2CBus.execute(this, file -> {
            file.write((int)b);
            return 1;
        });
    }

    public int write(byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        return this.i2CBus.execute(this, file -> {
            file.write(data, offset, length);
            return length;
        });
    }

    public int read() {
        return this.i2CBus.execute(this, RandomAccessFile::read);
    }

    public int read(byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        return this.i2CBus.execute(this, file -> file.read(buffer, offset, length));
    }

    public int writeRegister(int register, byte b) {
        return this.write(new byte[]{(byte)register, b});
    }

    public int writeRegister(int register, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        byte[] tmp = new byte[length + 1];
        tmp[0] = (byte)register;
        System.arraycopy(data, offset, tmp, 1, length);
        return this.write(tmp);
    }

    public int writeRegister(byte[] register, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        byte[] tmp = new byte[length + register.length];
        System.arraycopy(register, 0, tmp, 0, length);
        System.arraycopy(data, offset, tmp, register.length, length);
        int rc = this.write(tmp);
        return rc - register.length;
    }

    public int readRegister(int register) {
        return this.i2CBus.execute(this, file -> {
            file.write(register);
            return file.read();
        });
    }

    public int readRegister(int register, byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        return this.i2CBus.execute(this, file -> {
            file.write(register);
            return file.read(buffer, offset, length);
        });
    }

    public int readRegister(byte[] register, byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        long command = I2CConstants.I2C_RDWR;
        short deviceAddr = (short)(((I2CConfig)this.config).device() & 0xFF);
        short writeFlags = (short)(I2CConstants.I2C_SMBUS_WRITE & 0xFF);
        short writeLength = (short)register.length;
        IntBuffer offsets = IntBuffer.allocate(4);
        ByteBuffer ioctlData = ByteBuffer.allocate(500);
        ioctlData.order(ByteOrder.nativeOrder());
        ioctlData.putShort(deviceAddr);
        ioctlData.putShort(writeFlags);
        ioctlData.putShort(writeLength);
        int wrtAlignValue = ioctlData.position() % SystemUtil.getWordSize();
        if (ioctlData.position() < SystemUtil.getWordSize()) {
            ioctlData.position(SystemUtil.getWordSize() - ioctlData.position() + ioctlData.position());
        } else if (wrtAlignValue != 0) {
            ioctlData.position(ioctlData.position() + (SystemUtil.getWordSize() - wrtAlignValue));
        }
        offsets.put(ioctlData.position());
        byte[] wrtPtrData = new byte[SystemUtil.getWordSize()];
        ioctlData.put(wrtPtrData);
        short readFlags = (short)(I2CConstants.I2C_M_RD & 0xFF);
        short readLength = (short)length;
        byte[] readBuff = new byte[length];
        ioctlData.putShort(deviceAddr);
        ioctlData.putShort(readFlags);
        ioctlData.putShort(readLength);
        int rdAlignValue = ioctlData.position() % SystemUtil.getWordSize();
        if (ioctlData.position() < SystemUtil.getWordSize()) {
            ioctlData.position(SystemUtil.getWordSize() - ioctlData.position() + ioctlData.position());
        } else if (rdAlignValue != 0) {
            ioctlData.position(ioctlData.position() + (SystemUtil.getWordSize() - rdAlignValue));
        }
        byte[] rdPtrData = new byte[SystemUtil.getWordSize()];
        offsets.put(2, ioctlData.position());
        ioctlData.put(rdPtrData);
        int regBuffPosition = ioctlData.position();
        offsets.put(1, regBuffPosition);
        ioctlData.put(register);
        int readBuffPosition = ioctlData.position();
        offsets.put(3, readBuffPosition);
        ioctlData.put(readBuff);
        offsets.position(4);
        ioctlData.flip();
        offsets.flip();
        this.i2CBus.executeIOCTL(this, command, ioctlData, offsets);
        for (int i = 0; i < length; ++i) {
            buffer[i] = ioctlData.get(readBuffPosition + i);
        }
        return ioctlData.limit();
    }

    public int writeReadRegisterWord(int register, int word) {
        return this.i2CBus.execute(this, file -> {
            this.writeRegisterWord(register, word);
            return this.readRegisterWord(register);
        });
    }
}

