/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.i2c;

import com.pi4j.exception.Pi4JException;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.library.linuxfs.LinuxFile;
import com.pi4j.plugin.linuxfs.provider.i2c.CheckedFunction;
import com.pi4j.plugin.linuxfs.provider.i2c.I2CConstants;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsI2CBus {
    public static final long DEFAULT_LOCK_ACQUIRE_TIMEOUT = 1000L;
    public static final TimeUnit DEFAULT_LOCK_ACQUIRE_TIMEOUT_UNITS = TimeUnit.MILLISECONDS;
    private final Integer bus;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LinuxFile file;
    private int lastAddress;
    protected long lockAquireTimeout;
    protected TimeUnit lockAquireTimeoutUnit;
    private final ReentrantLock lock = new ReentrantLock(true);

    public LinuxFsI2CBus(I2CConfig config) {
        this.bus = config.getBus();
        File sysfs = new File("/sys/bus/i2c/devices/i2c-" + this.bus);
        if (!sysfs.exists() || !sysfs.isDirectory()) {
            throw new Pi4JException("I2C bus " + this.bus + " does not exist.");
        }
        File devfs = new File("/dev/i2c-" + this.bus);
        if (!(devfs.exists() && devfs.canRead() && devfs.canWrite())) {
            throw new Pi4JException("I2C bus " + this.bus + " does not exist.");
        }
        try {
            String fileName = devfs.getCanonicalPath();
            this.file = new LinuxFile(fileName, "rw");
        }
        catch (IOException e) {
            throw new Pi4JException((Throwable)e);
        }
        this.lockAquireTimeout = 1000L;
        this.lockAquireTimeoutUnit = DEFAULT_LOCK_ACQUIRE_TIMEOUT_UNITS;
    }

    protected void selectBusSlave(I2C i2c) throws IOException {
        if (this.lastAddress == i2c.device()) {
            return;
        }
        this.lastAddress = i2c.device();
        this.file.ioctl((long)I2CConstants.I2C_SLAVE, i2c.device() & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeIOCTL(I2C i2c, long command, ByteBuffer data, IntBuffer offsets) {
        int rc;
        block9: {
            rc = -1;
            if (this.lastAddress != i2c.device()) {
                this.lastAddress = i2c.device();
            }
            try {
                if (this.lock.tryLock() || this.lock.tryLock(this.lockAquireTimeout, this.lockAquireTimeoutUnit)) {
                    try {
                        this.selectBusSlave(i2c);
                        this.file.ioctl(command, data, offsets);
                        rc = 0;
                        return rc;
                    }
                    finally {
                        while (this.lock.isHeldByCurrentThread()) {
                            this.lock.unlock();
                        }
                        break block9;
                    }
                }
                throw new Pi4JException("Failed to get I2C lock on bus " + this.bus + " after " + this.lockAquireTimeout + " " + String.valueOf((Object)this.lockAquireTimeoutUnit));
            }
            catch (InterruptedException e) {
                this.logger.error("Failed locking " + this.getClass().getSimpleName() + "-" + this.bus, (Throwable)e);
                throw new RuntimeException("Could not obtain an access-lock!", e);
            }
            catch (Exception e) {
                throw new Pi4JException("Failed to execute action for device " + i2c.device() + " on bus " + this.bus, (Throwable)e);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R execute(I2C i2c, CheckedFunction<LinuxFile, R> action) {
        if (i2c == null) {
            throw new NullPointerException("Parameter 'i2c' is mandatory!");
        }
        if (action == null) {
            throw new NullPointerException("Parameter 'action' is mandatory!");
        }
        try {
            if (!this.lock.tryLock()) {
                if (!this.lock.tryLock(this.lockAquireTimeout, this.lockAquireTimeoutUnit)) throw new Pi4JException("Failed to get I2C lock on bus " + this.bus + " after " + this.lockAquireTimeout + " " + String.valueOf((Object)this.lockAquireTimeoutUnit));
            }
            try {
                this.selectBusSlave(i2c);
                R r = action.apply(this.file);
                return r;
            }
            finally {
                while (true) {
                    if (!this.lock.isHeldByCurrentThread()) {
                    }
                    this.lock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Failed locking " + this.getClass().getSimpleName() + "-" + this.bus, (Throwable)e);
            throw new RuntimeException("Could not obtain an access-lock!", e);
        }
        catch (Exception e) {
            throw new Pi4JException("Failed to execute action for device " + i2c.device() + " on bus " + this.bus, (Throwable)e);
        }
    }
}

