/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LinuxPwm {
    public static String DEFAULT_SYSTEM_PATH = "/sys/class/pwm";
    public static int DEFAULT_PWM_CHIP = 0;
    protected final String systemPath;
    protected final int chip;
    protected final int address;
    protected final String pwmPath;

    public LinuxPwm(String systemPath, int chip, int address) {
        this.chip = chip;
        this.address = address;
        this.systemPath = Paths.get(systemPath, String.format("pwmchip%d", chip)).toString();
        this.pwmPath = Paths.get(this.systemPath, String.format("pwm%d", address)).toString();
    }

    public LinuxPwm(String systemPath, int address) {
        this(DEFAULT_SYSTEM_PATH, DEFAULT_PWM_CHIP, address);
    }

    public LinuxPwm(int address) {
        this(DEFAULT_SYSTEM_PATH, address);
    }

    public int channels() throws IOException {
        return this.getChannels();
    }

    public int getChannels() throws IOException {
        Path path = Paths.get(this.systemPath, "npwm");
        return Integer.parseInt(Files.readString(path).trim());
    }

    public void export() throws IOException {
        Path path = Paths.get(this.systemPath, "export");
        Files.writeString(path, (CharSequence)Integer.toString(this.address), new OpenOption[0]);
    }

    public void unexport() throws IOException {
        Path path = Paths.get(this.systemPath, "unexport");
        Files.writeString(path, (CharSequence)Integer.toString(this.address), new OpenOption[0]);
    }

    public boolean isExported() throws IOException {
        return Files.exists(Paths.get(this.pwmPath, new String[0]), new LinkOption[0]);
    }

    public void polarity(Polarity polarity) throws IOException {
        this.setPolarity(polarity);
    }

    public void setPolarity(Polarity polarity) throws IOException {
        Path path = Paths.get(this.pwmPath, "polarity");
        Files.writeString(path, (CharSequence)polarity.name().toLowerCase(), new OpenOption[0]);
    }

    public Polarity polarity() throws IOException {
        return this.getPolarity();
    }

    public Polarity getPolarity() throws IOException {
        Path path = Paths.get(this.pwmPath, "polarity");
        switch (Files.readString(path).trim().toLowerCase()) {
            case "inversed": {
                return Polarity.INVERSED;
            }
            case "normal": {
                return Polarity.NORMAL;
            }
        }
        return Polarity.UNKNOWN;
    }

    public void enable() throws IOException {
        this.setEnabled(true);
    }

    public void disable() throws IOException {
        this.setEnabled(false);
    }

    public void enabled(boolean enabled) throws IOException {
        this.setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) throws IOException {
        Path path = Paths.get(this.pwmPath, "enable");
        Files.writeString(path, (CharSequence)(enabled ? "1" : "0"), new OpenOption[0]);
    }

    public boolean enabled() throws IOException {
        return this.isEnabled();
    }

    public boolean isEnabled() throws IOException {
        Path path = Paths.get(this.pwmPath, "enable");
        return Files.readString(path).trim().equalsIgnoreCase("1");
    }

    public void period(long period) throws IOException {
        this.setPeriod(period);
    }

    public void period(Number period) throws IOException {
        this.setPeriod(period);
    }

    public void setPeriod(long period) throws IOException {
        Path path = Paths.get(this.pwmPath, "period");
        Files.writeString(path, (CharSequence)Long.toUnsignedString(period), new OpenOption[0]);
    }

    public void setPeriod(Number period) throws IOException {
        Path path = Paths.get(this.pwmPath, "period");
        Files.writeString(path, (CharSequence)period.toString(), new OpenOption[0]);
    }

    public long period() throws IOException {
        return this.getPeriod();
    }

    public long getPeriod() throws IOException {
        Path path = Paths.get(this.pwmPath, "period");
        return Long.parseLong(Files.readString(path).trim());
    }

    public void dutyCycle(long dutyCycle) throws IOException {
        this.setDutyCycle(dutyCycle);
    }

    public void setDutyCycle(long dutyCycle) throws IOException {
        Path path = Paths.get(this.pwmPath, "duty_cycle");
        Files.writeString(path, (CharSequence)Long.toString(dutyCycle), new OpenOption[0]);
    }

    public long dutyCycle() throws IOException {
        return this.getDutyCycle();
    }

    public long getDutyCycle() throws IOException {
        Path path = Paths.get(this.pwmPath, "duty_cycle");
        return Long.parseLong(Files.readString(path).trim());
    }

    public String systemPath() {
        return this.getSystemPath();
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public String pwmPath() {
        return this.getPwmPath();
    }

    public String getPwmPath() {
        return this.pwmPath;
    }

    public static enum Polarity {
        NORMAL,
        INVERSED,
        UNKNOWN;

    }
}

