/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputBase;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.plugin.linuxfs.internal.LinuxGpio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsDigitalOutput
extends DigitalOutputBase
implements DigitalOutput {
    protected final LinuxGpio gpio;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public LinuxFsDigitalOutput(LinuxGpio gpio, DigitalOutputProvider provider, DigitalOutputConfig config) {
        super(provider, config);
        this.gpio = gpio;
    }

    public DigitalOutput initialize(Context context) throws InitializeException {
        this.logger.trace("initializing GPIO [" + ((DigitalOutputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        try {
            if (!this.gpio.isExported()) {
                this.logger.trace("exporting GPIO [" + ((DigitalOutputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
                this.gpio.export();
            } else {
                this.logger.trace("GPIO [" + ((DigitalOutputConfig)this.config).address() + "] is already exported; " + this.gpio.getPinPath());
            }
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException("Unable to export GPIO [" + ((DigitalOutputConfig)this.config).address() + "] @ <" + this.gpio.systemPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        try {
            this.logger.trace("set direction [OUT] on GPIO " + this.gpio.getPinPath());
            this.gpio.direction(LinuxGpio.Direction.OUT);
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException("Unable to set GPIO [" + ((DigitalOutputConfig)this.config).address() + "] DIRECTION=[OUT] @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        try {
            if (this.gpio.isInterruptSupported()) {
                this.gpio.interruptEdge(LinuxGpio.Edge.BOTH);
            }
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException("Unable to set GPIO [" + ((DigitalOutputConfig)this.config).address() + "] INTERRUPT EDGE=[BOTH] @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        super.initialize(context);
        return this;
    }

    public DigitalOutput shutdown(Context context) throws ShutdownException {
        this.logger.trace("shutdown GPIO [" + ((DigitalOutputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        if (((DigitalOutputConfig)this.config()).shutdownState() != null && ((DigitalOutputConfig)this.config()).shutdownState() != DigitalState.UNKNOWN) {
            return super.shutdown(context);
        }
        try {
            this.logger.trace("un-exporting GPIO [" + ((DigitalOutputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
            this.gpio.unexport();
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ShutdownException("Failed to UN-EXPORT GPIO [" + ((DigitalOutputConfig)this.config()).address() + "] @ <" + this.gpio.systemPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public DigitalOutput state(DigitalState state) throws IOException {
        this.logger.trace("set state [" + state.getName() + "] on GPIO [" + ((DigitalOutputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        try {
            this.gpio.state(state);
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage(), (Throwable)e);
        }
        return super.state(state);
    }

    public DigitalState state() {
        this.logger.trace("get state on GPIO [" + ((DigitalOutputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        try {
            DigitalState currentState = this.gpio.state();
            if (this.state != currentState) {
                this.state = currentState;
                this.logger.trace("state mismatch detected; sync internal state [" + this.state.getName() + "] on GPIO [" + ((DigitalOutputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
            }
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage(), (Throwable)e);
        }
        return super.state();
    }
}

