/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.internal;

import com.pi4j.io.gpio.digital.DigitalState;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LinuxGpio {
    public static String DEFAULT_SYSTEM_PATH = "/sys/class/gpio";
    protected final String systemPath;
    protected final int address;
    protected final String pinPath;

    public LinuxGpio(String systemPath, int address) {
        this.address = address;
        this.systemPath = systemPath;
        this.pinPath = Paths.get(systemPath, String.format("gpio%d", address)).toString();
    }

    public LinuxGpio(int address) {
        this(DEFAULT_SYSTEM_PATH, address);
    }

    public void export() throws IOException {
        Path path = Paths.get(this.systemPath, "export");
        Files.writeString(path, (CharSequence)Integer.toString(this.address), new OpenOption[0]);
    }

    public void unexport() throws IOException {
        Path path = Paths.get(this.systemPath, "unexport");
        Files.writeString(path, (CharSequence)Integer.toString(this.address), new OpenOption[0]);
    }

    public boolean isExported() throws IOException {
        return Files.exists(Paths.get(this.pinPath, new String[0]), new LinkOption[0]);
    }

    public boolean isInterruptSupported() throws IOException {
        return Files.exists(Paths.get(this.pinPath, "edge"), new LinkOption[0]);
    }

    public void direction(Direction direction) throws IOException {
        this.setDirection(direction);
    }

    public void setDirection(Direction direction) throws IOException {
        Path path = Paths.get(this.pinPath, "direction");
        Files.writeString(path, (CharSequence)direction.name().toLowerCase(), new OpenOption[0]);
    }

    public Direction direction() throws IOException {
        return this.getDirection();
    }

    public Direction getDirection() throws IOException {
        Path path = Paths.get(this.pinPath, "direction");
        switch (Files.readString(path).trim().toLowerCase()) {
            case "in": {
                return Direction.IN;
            }
            case "out": {
                return Direction.OUT;
            }
        }
        return Direction.UNKNOWN;
    }

    public void state(DigitalState state) throws IOException {
        this.setState(state);
    }

    public void setState(DigitalState state) throws IOException {
        Path path = Paths.get(this.pinPath, "value");
        Files.writeString(path, (CharSequence)(state.isHigh() ? "1" : "0"), new OpenOption[0]);
    }

    public DigitalState state() throws IOException {
        return this.getState();
    }

    public DigitalState getState() throws IOException {
        Path path = Paths.get(this.pinPath, "value");
        return DigitalState.parse((String)Files.readString(path).trim());
    }

    public void interruptEdge(Edge edge) throws IOException {
        this.setInterruptEdge(edge);
    }

    public void setInterruptEdge(Edge edge) throws IOException {
        Path path = Paths.get(this.pinPath, "edge");
        Files.writeString(path, (CharSequence)edge.name().toLowerCase(), new OpenOption[0]);
    }

    public Edge interruptEdge() throws IOException {
        return this.getInterruptEdge();
    }

    public Edge getInterruptEdge() throws IOException {
        Path path = Paths.get(this.pinPath, "edge");
        switch (Files.readString(path).trim().toLowerCase()) {
            case "none": {
                return Edge.NONE;
            }
            case "rising": {
                return Edge.RISING;
            }
            case "falling": {
                return Edge.FALLING;
            }
            case "both": {
                return Edge.BOTH;
            }
        }
        return Edge.UNKNOWN;
    }

    public void activeLow(boolean enabled) throws IOException {
        this.setActiveLow(enabled);
    }

    public void setActiveLow(boolean enabled) throws IOException {
        Path path = Paths.get(this.pinPath, "active_low");
        Files.writeString(path, (CharSequence)(enabled ? "1" : "0"), new OpenOption[0]);
    }

    public boolean activeLow() throws IOException {
        return this.getActiveLow();
    }

    public boolean getActiveLow() throws IOException {
        Path path = Paths.get(this.pinPath, "active_low");
        return Files.readString(path).trim().equalsIgnoreCase("1");
    }

    public String systemPath() {
        return this.getSystemPath();
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public String pinPath() {
        return this.getPinPath();
    }

    public String getPinPath() {
        return this.pinPath;
    }

    public static enum Direction {
        IN,
        OUT,
        UNKNOWN;

    }

    public static enum Edge {
        NONE,
        RISING,
        FALLING,
        BOTH,
        UNKNOWN;

    }
}

