/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.gpio.digital.Digital;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputBase;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.DigitalStateChangeEvent;
import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.plugin.linuxfs.internal.LinuxGpio;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsDigitalInput
extends DigitalInputBase
implements DigitalInput {
    protected final LinuxGpio gpio;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected DigitalState state = DigitalState.UNKNOWN;
    private Future<?> inputListener;

    public LinuxFsDigitalInput(LinuxGpio gpio, DigitalInputProvider provider, DigitalInputConfig config) {
        super(provider, config);
        this.gpio = gpio;
    }

    public DigitalInput initialize(Context context) throws InitializeException {
        this.logger.trace("initializing GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
        try {
            if (!this.gpio.isExported()) {
                this.logger.trace("exporting GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
                this.gpio.export();
            } else {
                this.logger.trace("GPIO [{}] is already exported; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException("Unable to export GPIO [" + ((DigitalInputConfig)this.config).address() + "] @ <" + this.gpio.systemPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        try {
            this.logger.trace("set direction [IN] on GPIO {}", (Object)this.gpio.getPinPath());
            this.gpio.direction(LinuxGpio.Direction.IN);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException("Unable to set GPIO [" + ((DigitalInputConfig)this.config).address() + "] DIRECTION=[IN] @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        if (((DigitalInputConfig)this.config).pull() == PullResistance.PULL_DOWN || ((DigitalInputConfig)this.config).pull() == PullResistance.PULL_UP || ((DigitalInputConfig)this.config).pull() == PullResistance.OFF) {
            // empty if block
        }
        try {
            this.state = this.gpio.state();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException("Unable to get GPIO [" + ((DigitalInputConfig)this.config).address() + "] state @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        try {
            if (this.gpio.isInterruptSupported()) {
                this.gpio.interruptEdge(LinuxGpio.Edge.BOTH);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException("Unable to set GPIO [" + ((DigitalInputConfig)this.config).address() + "] INTERRUPT EDGE=[BOTH] @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        super.initialize(context);
        this.logger.trace("start monitoring thread for GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
        Runnable monitorTask = () -> {
            try {
                WatchKey key;
                this.logger.trace("monitoring thread watching GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
                WatchService watchService = FileSystems.getDefault().newWatchService();
                Path path = Paths.get(this.gpio.getPinPath(), new String[0]);
                path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                while ((key = watchService.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        DigitalState newState;
                        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !event.context().toString().equalsIgnoreCase("value") || (newState = this.gpio.state()) == this.state) continue;
                        this.state = newState;
                        this.dispatch(new DigitalStateChangeEvent((Digital)this, newState));
                    }
                    key.reset();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        this.inputListener = context.submitTask(monitorTask);
        return this;
    }

    public DigitalInput shutdown(Context context) throws ShutdownException {
        this.logger.trace("shutdown GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
        this.logger.trace("shutdown monitoring thread for GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
        if (this.inputListener != null && !this.inputListener.cancel(true)) {
            this.logger.error("Failed to cancel input listener!");
        }
        super.shutdown(context);
        try {
            this.logger.trace("un-exporting GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
            this.gpio.unexport();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ShutdownException("Failed to UN-EXPORT GPIO [" + ((DigitalInputConfig)this.config()).address() + "] @ <" + this.gpio.systemPath() + ">; " + e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public DigitalState state() {
        this.logger.trace("get state on GPIO [{}]; {}", (Object)((DigitalInputConfig)this.config).address(), (Object)this.gpio.getPinPath());
        try {
            this.state = this.gpio.state();
            return this.state;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new com.pi4j.io.exception.IOException(e.getMessage(), (Throwable)e);
        }
    }
}

