/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.i2c;

import com.pi4j.common.CheckedFunction;
import com.pi4j.exception.Pi4JException;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CBusBase;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.library.linuxfs.LinuxFile;
import com.pi4j.plugin.linuxfs.provider.i2c.I2CConstants;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsI2CBus
extends I2CBusBase {
    private static final String SYSFS_BASE_PATH = "/sys/bus/i2c/devices/i2c-";
    private static final String DEVFS_BASE_PATH = "/dev/i2c-";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected LinuxFile file;
    private int lastAddress;

    public LinuxFsI2CBus(I2CConfig config) {
        super(config);
        this.validateSysFs();
        File devFs = this.validateAndGetDevFs();
        try {
            String fileName = devFs.getCanonicalPath();
            this.file = new LinuxFile(fileName, "rw");
        }
        catch (IOException e) {
            throw new Pi4JException("Failed to initialize I2C bus " + this.bus, (Throwable)e);
        }
    }

    private void validateSysFs() {
        String sysfsPath = SYSFS_BASE_PATH + this.bus;
        File sysfs = new File(sysfsPath);
        if (!sysfs.exists()) {
            throw new Pi4JException("Sysfs validation failed for I2C bus " + this.bus + ": path '" + sysfsPath + "' does not exist.");
        }
        if (!sysfs.isDirectory()) {
            throw new Pi4JException("Sysfs validation failed for I2C bus " + this.bus + ": path '" + sysfsPath + "' is not a directory.");
        }
    }

    private File validateAndGetDevFs() {
        String devfsPath = DEVFS_BASE_PATH + this.bus;
        File devfs = new File(devfsPath);
        if (!devfs.exists()) {
            throw new Pi4JException("Devfs validation failed for I2C bus " + this.bus + ": path '" + devfsPath + "' does not exist.");
        }
        if (!devfs.canRead()) {
            throw new Pi4JException("Devfs validation failed for I2C bus " + this.bus + ": path '" + devfsPath + "' is not readable.");
        }
        if (!devfs.canWrite()) {
            throw new Pi4JException("Devfs validation failed for I2C bus " + this.bus + ": path '" + devfsPath + "' is not writable.");
        }
        return devfs;
    }

    public <R> R execute(I2C i2c, Callable<R> action) {
        return (R)this._execute(i2c, () -> {
            try {
                this.selectBusSlave(i2c);
                return action.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Pi4JException("Failed to execute action for device " + i2c.device() + " on bus " + this.bus, (Throwable)e);
            }
        });
    }

    public <R> R execute(I2C i2c, CheckedFunction<LinuxFile, R> action) {
        return (R)this._execute(i2c, () -> {
            try {
                this.selectBusSlave(i2c);
                return action.apply((Object)this.file);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Pi4JException("Failed to execute action for device " + i2c.device() + " on bus " + this.bus, (Throwable)e);
            }
        });
    }

    public void executeIOCTL(I2C i2c, long command, ByteBuffer data, IntBuffer offsets) {
        this._execute(i2c, () -> {
            try {
                this.selectBusSlave(i2c);
                this.file.ioctl(command, data, offsets);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Pi4JException("Failed to execute ioctl for device " + i2c.device() + " on bus " + this.bus, (Throwable)e);
            }
            return null;
        });
    }

    protected void selectBusSlave(I2C i2c) throws IOException {
        if (this.lastAddress == i2c.device()) {
            return;
        }
        this.lastAddress = i2c.device();
        this.file.ioctl((long)I2CConstants.I2C_SLAVE, i2c.device() & 0xFF);
    }

    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close file {} for {}-{}", new Object[]{this.file, ((Object)((Object)this)).getClass().getSimpleName(), this.bus, e});
            }
        }
    }
}

