/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.spi;

import com.pi4j.io.exception.IOException;
import com.pi4j.io.spi.Spi;
import com.pi4j.io.spi.SpiBase;
import com.pi4j.io.spi.SpiConfig;
import com.pi4j.io.spi.SpiProvider;
import com.pi4j.plugin.linuxfs.internal.LinuxLibC;
import com.pi4j.plugin.linuxfs.provider.spi.LinuxFsSpiProviderImpl;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsSpi
extends SpiBase
implements Spi {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxFsSpi.class);
    private static final byte SPI_IOC_MAGIC = 107;
    private static final byte SIZE_OF_BYTE = 1;
    private static final byte SIZE_OF_INT = 4;
    private static final int SPI_IOC_RD_MODE = LinuxLibC._IOC((byte)2, (byte)107, (byte)1, 1);
    private static final int SPI_IOC_WR_MODE = LinuxLibC._IOC((byte)1, (byte)107, (byte)1, 1);
    private static final int SPI_IOC_RD_LSB_FIRST = LinuxLibC._IOC((byte)2, (byte)107, (byte)2, 1);
    private static final int SPI_IOC_WR_LSB_FIRST = LinuxLibC._IOC((byte)1, (byte)107, (byte)2, 1);
    private static final int SPI_IOC_RD_BITS_PER_WORD = LinuxLibC._IOC((byte)2, (byte)107, (byte)3, 1);
    private static final int SPI_IOC_WR_BITS_PER_WORD = LinuxLibC._IOC((byte)1, (byte)107, (byte)3, 1);
    private static final int SPI_IOC_RD_MAX_SPEED_HZ = LinuxLibC._IOC((byte)2, (byte)107, (byte)4, 4);
    private static final int SPI_IOC_WR_MAX_SPEED_HZ = LinuxLibC._IOC((byte)1, (byte)107, (byte)4, 4);
    private static final int SPI_IOC_RD_MODE32 = LinuxLibC._IOC((byte)2, (byte)107, (byte)5, 4);
    private static final int SPI_IOC_WR_MODE32 = LinuxLibC._IOC((byte)1, (byte)107, (byte)5, 4);
    private final byte SPI_CPHA = 1;
    private final byte SPI_CPOL = (byte)2;
    private final byte SPI_MODE_0 = 0;
    private final byte SPI_MODE_1 = 1;
    private final byte SPI_MODE_2 = (byte)2;
    private final byte SPI_MODE_3 = (byte)3;
    private final byte BITS8 = (byte)8;
    private static final String SPI_DEVICE_BASE = "/dev/spidev";
    private final LinuxLibC libc = LinuxLibC.INSTANCE;
    private int fd;

    private static int SPI_IOC_MESSAGE(int n) {
        int structSize = Native.getNativeSize(spi_ioc_transfer.ByValue.class);
        int msgSize = n * structSize < 16384 ? n * structSize : 0;
        return LinuxLibC._IOC((byte)1, (byte)107, (byte)0, msgSize);
    }

    public LinuxFsSpi(LinuxFsSpiProviderImpl provider, SpiConfig config) {
        super((SpiProvider)provider, config);
    }

    public void open() {
        super.open();
        String spiDev = SPI_DEVICE_BASE + ((SpiConfig)this.config()).bus().getBus() + "." + ((SpiConfig)this.config()).getChipSelect().getChipSelect();
        this.fd = this.libc.open(spiDev, 2);
        if (this.fd < 0) {
            throw new RuntimeException("Failed to open SPI device " + spiDev);
        }
        IntByReference intPtr = new IntByReference();
        int ret = this.libc.ioctl(this.fd, SPI_IOC_RD_MODE32, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not read SPI mode.");
        }
        if (((SpiConfig)this.config()).flags() != null) {
            throw new IOException("Unsupported SPI Pi5 parameter flags");
        }
        switch (((SpiConfig)this.config()).mode()) {
            case MODE_0: {
                intPtr.setValue(intPtr.getValue() | 0);
                break;
            }
            case MODE_1: {
                intPtr.setValue(intPtr.getValue() | 1);
                break;
            }
            case MODE_2: {
                intPtr.setValue(intPtr.getValue() | 2);
                break;
            }
            case MODE_3: {
                intPtr.setValue(intPtr.getValue() | 3);
            }
        }
        ret = this.libc.ioctl(this.fd, SPI_IOC_WR_MODE32, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not write SPI mode..");
        }
        intPtr.setValue(((SpiConfig)this.config()).baud().intValue());
        ret = this.libc.ioctl(this.fd, SPI_IOC_RD_MAX_SPEED_HZ, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not read the SPI max speed.");
        }
        intPtr.setValue(((SpiConfig)this.config()).baud().intValue());
        ret = this.libc.ioctl(this.fd, SPI_IOC_WR_MAX_SPEED_HZ, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not write the SPI max speed.");
        }
        intPtr.setValue(8);
        ret = this.libc.ioctl(this.fd, SPI_IOC_WR_BITS_PER_WORD, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not write the SPI BITS per write.");
        }
        intPtr.setValue(8);
        ret = this.libc.ioctl(this.fd, SPI_IOC_RD_BITS_PER_WORD, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not write the SPI BITS per read.");
        }
        intPtr.setValue(((SpiConfig)this.config()).readLsbFirst().intValue());
        ret = this.libc.ioctl(this.fd, SPI_IOC_RD_LSB_FIRST, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not write the SPI SHIFT read.");
        }
        intPtr.setValue(((SpiConfig)this.config()).writeLsbFirst().intValue());
        ret = this.libc.ioctl(this.fd, SPI_IOC_WR_LSB_FIRST, intPtr);
        if (ret != 0) {
            this.libc.close(this.fd);
            throw new RuntimeException("Could not write the SPI SHIFT write.");
        }
    }

    public void close() {
        this.libc.close(this.fd);
        super.close();
    }

    public int transfer(byte[] write, int writeOffset, byte[] read, int readOffset, int numberOfBytes) {
        PeerAccessibleMemory buf = new PeerAccessibleMemory(numberOfBytes);
        buf.write(0L, write, writeOffset, numberOfBytes);
        spi_ioc_transfer transfer = new spi_ioc_transfer();
        transfer.tx_buf = buf.getPeer();
        transfer.rx_buf = buf.getPeer();
        transfer.bits_per_word = (byte)8;
        transfer.speed_hz = ((SpiConfig)this.config).baud();
        transfer.delay_usecs = 0;
        transfer.len = numberOfBytes;
        int ret = this.libc.ioctl(this.fd, LinuxFsSpi.SPI_IOC_MESSAGE(1), new Object[]{transfer});
        if (ret < 0) {
            LOG.error("Could not write SPI message. ret {}, error: {}", (Object)ret, (Object)Native.getLastError());
            numberOfBytes = -1;
        } else {
            buf.read(0L, read, readOffset, numberOfBytes);
        }
        buf.close();
        return numberOfBytes;
    }

    public int read() {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == 1) {
            return buf[0];
        }
        return -1;
    }

    public int read(byte[] read, int offset, int length) {
        PeerAccessibleMemory buf = new PeerAccessibleMemory(length);
        spi_ioc_transfer transfer = new spi_ioc_transfer();
        transfer.tx_buf = 0L;
        transfer.rx_buf = buf.getPeer();
        transfer.bits_per_word = (byte)8;
        transfer.speed_hz = ((SpiConfig)this.config).baud();
        transfer.delay_usecs = 0;
        transfer.len = length;
        int ret = this.libc.ioctl(this.fd, LinuxFsSpi.SPI_IOC_MESSAGE(1), new Object[]{transfer});
        if (ret < 0) {
            LOG.error("Could not write SPIIOC  message. ret {}, error: {}", (Object)ret, (Object)Native.getLastError());
            length = -1;
        } else {
            buf.read(0L, read, offset, length);
        }
        buf.close();
        return length;
    }

    public int write(byte b) {
        return this.write(new byte[]{b}, 0, 1);
    }

    public int write(byte[] data, int offset, int length) {
        PeerAccessibleMemory buf = new PeerAccessibleMemory(length);
        buf.write(0L, data, offset, length);
        spi_ioc_transfer transfer = new spi_ioc_transfer();
        transfer.tx_buf = buf.getPeer();
        transfer.rx_buf = 0L;
        transfer.bits_per_word = (byte)8;
        transfer.speed_hz = ((SpiConfig)this.config).baud();
        transfer.delay_usecs = 0;
        transfer.len = length;
        int ret = this.libc.ioctl(this.fd, LinuxFsSpi.SPI_IOC_MESSAGE(1), new Object[]{transfer});
        if (ret < 0) {
            LOG.error("Could not write SPI message. ret {}, error: {}", (Object)ret, (Object)Native.getLastError());
            length = 0;
        }
        buf.close();
        return length;
    }

    @Structure.FieldOrder(value={"tx_buf", "rx_buf", "len", "speed_hz", "delay_usecs", "bits_per_word", "cs_change", "tx_nbits", "rx_nbits", "word_delay_usecs", "pad"})
    public static class spi_ioc_transfer
    extends Structure {
        public long tx_buf;
        public long rx_buf;
        public int len;
        public int speed_hz;
        public short delay_usecs;
        public byte bits_per_word;
        public byte cs_change;
        public byte tx_nbits;
        public byte rx_nbits;
        public byte word_delay_usecs;
        public byte pad;

        public static class ByValue
        extends spi_ioc_transfer
        implements Structure.ByValue {
        }
    }

    private static class PeerAccessibleMemory
    extends Memory {
        public PeerAccessibleMemory(long size) {
            super(size);
        }

        long getPeer() {
            return this.peer;
        }
    }
}

