/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.extension.Plugin;
import com.pi4j.extension.PluginService;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.i2c.PiGpioI2CProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.provider.Provider;

public class PiGpioPlugin
implements Plugin {
    public static final String NAME = "PiGpio";
    public static final String ID = "pigpio";
    public static final String DIGITAL_INPUT_PROVIDER_NAME = "PiGpio Digital Input (GPIO) Provider";
    public static final String DIGITAL_INPUT_PROVIDER_ID = "pigpio-digital-input";
    public static final String DIGITAL_OUTPUT_PROVIDER_NAME = "PiGpio Digital Output (GPIO) Provider";
    public static final String DIGITAL_OUTPUT_PROVIDER_ID = "pigpio-digital-output";
    public static final String PWM_PROVIDER_NAME = "PiGpio PWM Provider";
    public static final String PWM_PROVIDER_ID = "pigpio-pwm";
    public static final String HW_PWM_PROVIDER_NAME = "PiGpio Hardware PWM Provider";
    public static final String HW_PWM_PROVIDER_ID = "pigpio-hardware-pwm";
    public static final String I2C_PROVIDER_NAME = "PiGpio I2C Provider";
    public static final String I2C_PROVIDER_ID = "pigpio-i2c";
    public static final String SPI_PROVIDER_NAME = "PiGpio SPI Provider";
    public static final String SPI_PROVIDER_ID = "pigpio-spi";
    public static final String SERIAL_PROVIDER_NAME = "PiGpio Serial Provider";
    public static final String SERIAL_PROVIDER_ID = "pigpio-serial";
    protected PiGpio piGpio = null;
    public static String PI4J_HOST_PROPERTY = "pi4j.host";
    public static String PIGPIO_HOST_PROPERTY = "pi4j.pigpio.host";
    public static String PIGPIO_PORT_PROPERTY = "pi4j.pigpio.port";
    public static String DEFAULT_PIGPIO_HOST = "127.0.0.1";
    public static Integer DEFAULT_PIGPIO_PORT = 8888;
    public static Boolean DEFAULT_PIGPIO_REMOTE = false;

    public void initialize(PluginService service) throws InitializeException {
        Boolean remote = DEFAULT_PIGPIO_REMOTE;
        String host = DEFAULT_PIGPIO_HOST;
        int port = DEFAULT_PIGPIO_PORT;
        if (service.context().properties().has("remote")) {
            remote = Boolean.parseBoolean(service.context().properties().get("remote", remote.toString()));
        }
        if (service.context().properties().has("pipgio.remote")) {
            remote = Boolean.parseBoolean(service.context().properties().get("pigpio.remote", remote.toString()));
        }
        if (remote.booleanValue()) {
            if (service.context().properties().has("host")) {
                host = service.context().properties().get("host", host);
            }
            if (service.context().properties().has("pipgio.host")) {
                host = service.context().properties().get("pigpio.host", host);
            }
            if (service.context().properties().has("port")) {
                port = Integer.parseInt(service.context().properties().get("port", Integer.toString(port)));
            }
            if (service.context().properties().has("pipgio.port")) {
                port = Integer.parseInt(service.context().properties().get("pipgio.port", Integer.toString(port)));
            }
            this.piGpio = PiGpio.newSocketInstance((String)host, (int)port);
        } else {
            this.piGpio = PiGpio.newNativeInstance();
        }
        Provider[] providers = new Provider[]{PiGpioDigitalInputProvider.newInstance(this.piGpio), PiGpioDigitalOutputProvider.newInstance(this.piGpio), PiGpioPwmProvider.newInstance(this.piGpio), PiGpioI2CProvider.newInstance(this.piGpio), PiGpioSerialProvider.newInstance(this.piGpio), PiGpioSpiProvider.newInstance(this.piGpio)};
        service.register(providers);
    }

    public void shutdown(Context context) throws ShutdownException {
        if (this.piGpio != null && this.piGpio.isInitialized()) {
            this.piGpio.shutdown();
        }
    }
}

