/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.i2c;

import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.io.IO;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CProviderBase;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.pigpio.provider.i2c.PiGpioI2C;
import com.pi4j.plugin.pigpio.provider.i2c.PiGpioI2CBus;
import com.pi4j.plugin.pigpio.provider.i2c.PiGpioI2CProvider;
import java.util.HashMap;
import java.util.Map;

public class PiGpioI2CProviderImpl
extends I2CProviderBase
implements PiGpioI2CProvider {
    final PiGpio piGpio;
    private final Map<Integer, PiGpioI2CBus> i2CBusMap;

    public PiGpioI2CProviderImpl(PiGpio piGpio) {
        this.id = "pigpio-i2c";
        this.name = "PiGpio I2C Provider";
        this.piGpio = piGpio;
        this.i2CBusMap = new HashMap<Integer, PiGpioI2CBus>();
    }

    public int getPriority() {
        return BoardInfoHelper.usesRP1() ? 50 : 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2C create(I2CConfig config) {
        PiGpio piGpio = this.piGpio;
        synchronized (piGpio) {
            if (!this.piGpio.isInitialized()) {
                this.piGpio.initialize();
            }
            PiGpioI2CBus i2CBus = this.i2CBusMap.computeIfAbsent(config.getBus(), busNr -> new PiGpioI2CBus(config));
            PiGpioI2C i2C = new PiGpioI2C(this.piGpio, i2CBus, this, config);
            this.context.registry().add((IO)i2C);
            return i2C;
        }
    }
}

