/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.pwm;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmBase;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.library.pigpio.PiGpio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PiGpioPwmBase
extends PwmBase
implements Pwm {
    protected final PiGpio piGpio;
    protected final int range;
    protected int actualFrequency = -1;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PiGpioPwmBase(PiGpio piGpio, PwmProvider provider, PwmConfig config, int range) {
        super(provider, config);
        this.piGpio = piGpio;
        this.range = range;
    }

    protected int calculateActualDutyCycle(float dutyCycle) {
        return Math.round((float)this.range * dutyCycle / 100.0f);
    }

    public int getActualFrequency() {
        return this.actualFrequency;
    }

    public Pwm initialize(Context context) throws InitializeException {
        return super.initialize(context);
    }
}

