/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.serial;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialBase;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialProvider;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioMode;

public class PiGpioSerial
extends SerialBase
implements Serial {
    protected final PiGpio piGpio;
    protected final int handle;

    public PiGpioSerial(PiGpio piGpio, SerialProvider provider, SerialConfig config) {
        super(provider, config);
        this.piGpio = piGpio;
        if (config.device().endsWith("ttyS0")) {
            piGpio.gpioSetMode(14, PiGpioMode.ALT5);
            piGpio.gpioSetMode(15, PiGpioMode.ALT5);
        }
        this.handle = piGpio.serOpen((CharSequence)config.device(), config.baud().intValue());
        this.isOpen = true;
    }

    public Serial initialize(Context context) throws InitializeException {
        super.initialize(context);
        return this;
    }

    public int available() {
        return this.piGpio.serDataAvailable(this.handle);
    }

    public void close() {
        this.piGpio.serClose(this.handle);
        super.close();
    }

    public int write(byte b) {
        return this.piGpio.serWriteByte(this.handle, b);
    }

    public int write(byte[] data, int offset, int length) {
        return this.piGpio.serWrite(this.handle, data, offset, length);
    }

    public int read() {
        return this.piGpio.serReadByte(this.handle);
    }

    public int read(byte[] buffer, int offset, int length) {
        return this.piGpio.serRead(this.handle, buffer, offset, length);
    }

    public int drain() {
        return this.piGpio.serDrain(this.handle);
    }
}

