/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputBase;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioException;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.library.pigpio.PiGpioState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioDigitalOutput
extends DigitalOutputBase
implements DigitalOutput {
    private final PiGpio piGpio;
    private final int pin;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PiGpioDigitalOutput(PiGpio piGpio, DigitalOutputProvider provider, DigitalOutputConfig config) {
        super(provider, config);
        this.piGpio = piGpio;
        this.pin = config.address();
    }

    public DigitalOutput initialize(Context context) throws InitializeException {
        super.initialize(context);
        try {
            this.piGpio.gpioSetMode(this.pin, PiGpioMode.OUTPUT);
        }
        catch (PiGpioException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InitializeException((Throwable)e);
        }
        return this;
    }

    public DigitalOutput state(DigitalState state) throws IOException {
        try {
            this.piGpio.gpioWrite(this.pin, PiGpioState.from((Number)state.value()));
        }
        catch (PiGpioException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage(), (Throwable)e);
        }
        return super.state(state);
    }
}

