/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.spi;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.spi.Spi;
import com.pi4j.io.spi.SpiBase;
import com.pi4j.io.spi.SpiBus;
import com.pi4j.io.spi.SpiConfig;
import com.pi4j.io.spi.SpiMode;
import com.pi4j.io.spi.SpiProvider;
import com.pi4j.library.pigpio.PiGpio;

public class PiGpioSpi
extends SpiBase
implements Spi {
    protected final PiGpio piGpio;
    protected final int handle;
    protected static int SPI_BUS_MASK = 256;
    protected static int SPI_MODE_MASK = 3;
    protected static int SPI_WRITE_LSB_FIRST_MASK = 16384;
    protected static int SPI_READ_LSB_FIRST_MASK = 32768;

    public PiGpioSpi(PiGpio piGpio, SpiProvider provider, SpiConfig config) {
        super(provider, config);
        this.piGpio = piGpio;
        SpiBus bus = config.bus();
        SpiMode mode = config.mode();
        int flags = 0;
        if (((SpiConfig)this.config()).flags() != null) {
            flags = ((SpiConfig)this.config()).flags().intValue();
        }
        if (bus.getBus() > 1) {
            throw new IOException("Unsupported BUS by PiGPIO SPI Provider: bus=" + bus.toString());
        }
        if (bus == SpiBus.BUS_0 && config.address() == 2) {
            throw new IOException("Unsupported SPI channel (chip select) on SPI BUS_0 bus: address=" + config.address());
        }
        if (bus == SpiBus.BUS_1 && (mode == SpiMode.MODE_1 || mode == SpiMode.MODE_3)) {
            throw new IOException("Unsupported SPI mode on AUX SPI BUS_1: mode=" + mode.toString());
        }
        if (config.writeLsbFirstUserProvided()) {
            flags = ((SpiConfig)this.config()).getWriteLsbFirst() == 0 ? (flags |= 0xFFFFFFFF ^ SPI_WRITE_LSB_FIRST_MASK) : flags | 0xFFFFFFFF ^ SPI_WRITE_LSB_FIRST_MASK | SPI_WRITE_LSB_FIRST_MASK;
        }
        if (config.readLsbFirstUserProvided()) {
            flags = ((SpiConfig)this.config()).getReadLsbFirst() == 0 ? (flags |= 0xFFFFFFFF ^ SPI_READ_LSB_FIRST_MASK) : flags | 0xFFFFFFFF ^ SPI_READ_LSB_FIRST_MASK | SPI_READ_LSB_FIRST_MASK;
        }
        if (config.busUserProvided()) {
            if (bus == SpiBus.BUS_0) {
                flags &= 0xFFFFFFFF ^ SPI_BUS_MASK;
            } else if (bus == SpiBus.BUS_1) {
                flags = flags & (0xFFFFFFFF ^ SPI_BUS_MASK) | SPI_BUS_MASK;
            }
        }
        if (config.modeUserProvided()) {
            flags = flags & (0xFFFFFFFF ^ SPI_MODE_MASK) | mode.getMode();
        }
        this.handle = piGpio.spiOpen(config.address().intValue(), config.baud().intValue(), flags);
        this.isOpen = true;
    }

    public Spi initialize(Context context) throws InitializeException {
        super.initialize(context);
        return this;
    }

    public void close() {
        this.piGpio.spiClose(this.handle);
        super.close();
    }

    public int transfer(byte[] write, int writeOffset, byte[] read, int readOffset, int numberOfBytes) {
        return this.piGpio.spiXfer(this.handle, write, writeOffset, read, readOffset, numberOfBytes);
    }

    public int write(byte b) {
        return this.piGpio.spiWriteByte(this.handle, b);
    }

    public int write(byte[] data, int offset, int length) {
        return this.piGpio.spiWrite(this.handle, data, offset, length);
    }

    public int read() {
        return this.piGpio.spiReadByte(this.handle);
    }

    public int read(byte[] buffer, int offset, int length) {
        return this.piGpio.spiRead(this.handle, buffer, offset, length);
    }
}

