/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public final class SQLOrderBy
extends SQLObjectImpl {
    protected final List<SQLSelectOrderByItem> items = new ArrayList<SQLSelectOrderByItem>();
    private boolean sibings;

    public SQLOrderBy() {
    }

    public SQLOrderBy(SQLExpr expr) {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem(expr);
        this.addItem(item);
    }

    public SQLOrderBy(SQLExpr expr, SQLOrderingSpecification type) {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem(expr, type);
        this.addItem(item);
    }

    public void addItem(SQLSelectOrderByItem item) {
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(item);
    }

    public void addItem(SQLExpr item) {
        this.addItem(new SQLSelectOrderByItem(item));
    }

    public List<SQLSelectOrderByItem> getItems() {
        return this.items;
    }

    public boolean isSibings() {
        return this.sibings;
    }

    public void setSibings(boolean sibings) {
        this.sibings = sibings;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.items);
        }
        visitor.endVisit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.sibings ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLOrderBy other = (SQLOrderBy)obj;
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        return this.sibings == other.sibings;
    }

    public void addItem(SQLExpr expr, SQLOrderingSpecification type) {
        SQLSelectOrderByItem item = this.createItem();
        item.setExpr(expr);
        item.setType(type);
        this.addItem(item);
    }

    protected SQLSelectOrderByItem createItem() {
        return new SQLSelectOrderByItem();
    }

    @Override
    public SQLOrderBy clone() {
        SQLOrderBy x = new SQLOrderBy();
        for (SQLSelectOrderByItem item : this.items) {
            SQLSelectOrderByItem item1 = item.clone();
            item1.setParent(x);
            x.items.add(item1);
        }
        x.sibings = this.sibings;
        return x;
    }
}

