/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel;

import com.pig4cloud.plugin.excel.ExcelHandlerConfiguration;
import com.pig4cloud.plugin.excel.aop.DynamicNameAspect;
import com.pig4cloud.plugin.excel.aop.RequestExcelArgumentResolver;
import com.pig4cloud.plugin.excel.aop.ResponseExcelReturnValueHandler;
import com.pig4cloud.plugin.excel.config.ExcelConfigProperties;
import com.pig4cloud.plugin.excel.processor.NameProcessor;
import com.pig4cloud.plugin.excel.processor.NameSpelExpressionProcessor;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@AutoConfiguration
@Import(value={ExcelHandlerConfiguration.class})
@EnableConfigurationProperties(value={ExcelConfigProperties.class})
public class ResponseExcelAutoConfiguration {
    private final RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private final ResponseExcelReturnValueHandler responseExcelReturnValueHandler;

    @Bean
    @ConditionalOnMissingBean
    public NameProcessor nameProcessor() {
        return new NameSpelExpressionProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicNameAspect dynamicNameAspect(NameProcessor nameProcessor) {
        return new DynamicNameAspect(nameProcessor);
    }

    @PostConstruct
    public void setReturnValueHandlers() {
        List returnValueHandlers = this.requestMappingHandlerAdapter.getReturnValueHandlers();
        ArrayList<ResponseExcelReturnValueHandler> newHandlers = new ArrayList<ResponseExcelReturnValueHandler>();
        newHandlers.add(this.responseExcelReturnValueHandler);
        assert (returnValueHandlers != null);
        newHandlers.addAll(returnValueHandlers);
        this.requestMappingHandlerAdapter.setReturnValueHandlers(newHandlers);
    }

    @PostConstruct
    public void setRequestExcelArgumentResolver() {
        List argumentResolvers = this.requestMappingHandlerAdapter.getArgumentResolvers();
        ArrayList<RequestExcelArgumentResolver> resolverList = new ArrayList<RequestExcelArgumentResolver>();
        resolverList.add(new RequestExcelArgumentResolver());
        resolverList.addAll(argumentResolvers);
        this.requestMappingHandlerAdapter.setArgumentResolvers(resolverList);
    }

    public ResponseExcelAutoConfiguration(RequestMappingHandlerAdapter requestMappingHandlerAdapter, ResponseExcelReturnValueHandler responseExcelReturnValueHandler) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
        this.responseExcelReturnValueHandler = responseExcelReturnValueHandler;
    }
}

