/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.converters;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.text.ParseException;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum StringArrayConverter implements Converter<String[]>
{
    INSTANCE;


    public Class supportJavaTypeKey() {
        return String[].class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public String[] convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws ParseException {
        return cellData.getStringValue().split(",");
    }

    public WriteCellData<String> convertToExcelData(String[] value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return new WriteCellData(Arrays.stream(value).collect(Collectors.joining()));
    }
}

