/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.aop;

import com.pig4cloud.plugin.excel.annotation.ResponseExcel;
import com.pig4cloud.plugin.excel.processor.NameProcessor;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
public class DynamicNameAspect {
    public static final String EXCEL_NAME_KEY = "__EXCEL_NAME_KEY__";
    public static final String EXCEL_INCLUDES_KEY = "__EXCEL_INCLUDES_KEY__";
    private final NameProcessor processor;

    @Before(value="@annotation(excel)")
    public void around(JoinPoint point, ResponseExcel excel) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        String name = excel.name();
        name = !StringUtils.hasText((String)name) ? LocalDateTime.now().toString() : this.processor.doDetermineName(point.getArgs(), ms.getMethod(), excel.name());
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Objects.requireNonNull(requestAttributes).setAttribute(EXCEL_NAME_KEY, (Object)name, 0);
        if (excel.include().length == 1) {
            String includeFields = this.processor.doDetermineName(point.getArgs(), ms.getMethod(), excel.include()[0]);
            if (!StringUtils.hasText((String)includeFields)) {
                return;
            }
            List includes = Arrays.stream(includeFields.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            Objects.requireNonNull(requestAttributes).setAttribute(EXCEL_INCLUDES_KEY, includes, 0);
        }
    }

    @Generated
    public DynamicNameAspect(NameProcessor processor) {
        this.processor = processor;
    }
}

