/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.mcp;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.model.Port;
import com.alibaba.nacos.istio.model.mcp.Metadata;
import com.alibaba.nacos.istio.model.mcp.RequestResources;
import com.alibaba.nacos.istio.model.mcp.Resource;
import com.alibaba.nacos.istio.model.mcp.ResourceSourceGrpc;
import com.alibaba.nacos.istio.model.mcp.Resources;
import com.alibaba.nacos.istio.model.naming.ServiceEntry;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.google.protobuf.Any;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NacosMcpService
extends ResourceSourceGrpc.ResourceSourceImplBase {
    private final AtomicInteger connectIdGenerator = new AtomicInteger(0);
    private final Map<Integer, StreamObserver<Resources>> connnections = new ConcurrentHashMap<Integer, StreamObserver<Resources>>(16);
    private final Map<String, Resource> resourceMap = new ConcurrentHashMap<String, Resource>(16);
    private final Map<String, String> checksumMap = new ConcurrentHashMap<String, String>(16);
    private static final String SERVICE_NAME_SPLITTER = "nacos";
    private static final String MESSAGE_TYPE_URL = "type.googleapis.com/istio.networking.v1alpha3.ServiceEntry";
    private static final long MCP_PUSH_PERIOD_MILLISECONDS = 10000L;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private IstioConfig istioConfig;

    @PostConstruct
    public void init() {
        if (!this.istioConfig.isMcpServerEnabled()) {
            return;
        }
        GlobalExecutor.scheduleMcpPushTask((Runnable)new McpPushTask(), (long)20000L, (long)10000L);
    }

    private String convertName(com.alibaba.nacos.naming.core.Service service) {
        String serviceName = NamingUtils.getServiceName((String)service.getName()) + ".sn";
        if (!"DEFAULT_GROUP".equals(NamingUtils.getGroupName((String)service.getName()))) {
            serviceName = serviceName + NamingUtils.getGroupName((String)service.getName()) + ".gn";
        }
        if (!"public".equals(service.getNamespaceId())) {
            serviceName = serviceName + service.getNamespaceId() + ".ns";
        }
        return serviceName;
    }

    private Resource convertService(com.alibaba.nacos.naming.core.Service service) {
        String serviceName = this.convertName(service);
        ServiceEntry.Builder serviceEntryBuilder = ServiceEntry.newBuilder().setResolution(ServiceEntry.Resolution.STATIC).setLocation(ServiceEntry.Location.MESH_INTERNAL).addHosts(serviceName + "." + SERVICE_NAME_SPLITTER).addPorts(Port.newBuilder().setNumber(8848).setName("http").setProtocol("HTTP").build());
        for (Instance instance : service.allIPs()) {
            if (!instance.isHealthy() || !instance.isEnabled()) continue;
            ServiceEntry.Endpoint endpoint = ServiceEntry.Endpoint.newBuilder().setAddress(instance.getIp()).setWeight((int)instance.getWeight()).putAllLabels(instance.getMetadata()).putPorts("http", instance.getPort()).build();
            serviceEntryBuilder.addEndpoints(endpoint);
        }
        ServiceEntry serviceEntry = serviceEntryBuilder.build();
        Any any = Any.newBuilder().setValue(serviceEntry.toByteString()).setTypeUrl(MESSAGE_TYPE_URL).build();
        Metadata metadata = Metadata.newBuilder().setName("nacos/" + serviceName).putAllAnnotations(service.getMetadata()).putAnnotations("virtual", "1").build();
        Resource resource = Resource.newBuilder().setBody(any).setMetadata(metadata).build();
        return resource;
    }

    @Override
    public StreamObserver<RequestResources> establishResourceStream(final StreamObserver<Resources> responseObserver) {
        final int id = this.connectIdGenerator.incrementAndGet();
        this.connnections.put(id, responseObserver);
        return new StreamObserver<RequestResources>(){
            private final int connectionId;
            {
                this.connectionId = id;
            }

            public void onNext(RequestResources value) {
                Loggers.MAIN.info("receiving request, sink: {}, type: {}", (Object)value.getSinkNode(), (Object)value.getCollection());
                if (value.getErrorDetail() != null && value.getErrorDetail().getCode() != 0) {
                    Loggers.MAIN.error("NACK error code: {}, message: {}", (Object)value.getErrorDetail().getCode(), (Object)value.getErrorDetail().getMessage());
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)value.getResponseNonce())) {
                    Loggers.MAIN.info("ACK nonce: {}, type: {}", (Object)value.getResponseNonce(), (Object)value.getCollection());
                    return;
                }
                if (!"istio/networking/v1alpha3/serviceentries".equals(value.getCollection())) {
                    Resources resources = Resources.newBuilder().setCollection(value.getCollection()).setNonce(String.valueOf(System.currentTimeMillis())).build();
                    responseObserver.onNext((Object)resources);
                }
            }

            public void onError(Throwable t) {
                Loggers.MAIN.error("stream error.", t);
                NacosMcpService.this.connnections.remove(this.connectionId);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private class McpPushTask
    implements Runnable {
        private McpPushTask() {
        }

        @Override
        public void run() {
            boolean changed = false;
            Set namespaces = NacosMcpService.this.serviceManager.getAllNamespaces();
            for (String namespace : namespaces) {
                Map services = NacosMcpService.this.serviceManager.getServiceMap(namespace);
                if (services.isEmpty()) continue;
                for (com.alibaba.nacos.naming.core.Service service : services.values()) {
                    String convertedName = NacosMcpService.this.convertName(service);
                    if (NacosMcpService.this.checksumMap.containsKey(convertedName) && ((String)NacosMcpService.this.checksumMap.get(convertedName)).equals(service.getChecksum())) continue;
                    if (service.allIPs().isEmpty()) {
                        NacosMcpService.this.resourceMap.remove(convertedName);
                        continue;
                    }
                    changed = true;
                    NacosMcpService.this.resourceMap.put(convertedName, NacosMcpService.this.convertService(service));
                    NacosMcpService.this.checksumMap.put(convertedName, service.getChecksum());
                }
            }
            if (!changed) {
                return;
            }
            Resources resources = Resources.newBuilder().addAllResources(NacosMcpService.this.resourceMap.values()).setCollection("istio/networking/v1alpha3/serviceentries").setNonce(String.valueOf(System.currentTimeMillis())).build();
            if (NacosMcpService.this.connnections.isEmpty()) {
                return;
            }
            Loggers.MAIN.info("MCP push, resource count is: {}", (Object)NacosMcpService.this.resourceMap.size());
            if (Loggers.MAIN.isDebugEnabled()) {
                Loggers.MAIN.debug("MCP push, sending resources: {}", (Object)resources);
            }
            for (StreamObserver observer : NacosMcpService.this.connnections.values()) {
                observer.onNext((Object)resources);
            }
        }
    }
}

